<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2014 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" />

    <!-- view -->

    <xsl:template match="pattern" mode="table_of_contents_views">
        <xsl:for-each select="solution/view">
            <li>
                <xsl:choose>
                    <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')">
                        <xsl:choose>
                            <xsl:when test="@name"><xsl:value-of select="@name" /></xsl:when>
                            <xsl:otherwise>View</xsl:otherwise>
                        </xsl:choose>
                    </a></xsl:when>
                    <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')">
                        <xsl:choose>
                            <xsl:when test="@name"><xsl:value-of select="@name" /></xsl:when>
                            <xsl:otherwise>View</xsl:otherwise>
                        </xsl:choose>
                    </a></xsl:otherwise>
                </xsl:choose>
                <xsl:if test="diagrams or gui or classes">
                    <ul>
                        <xsl:apply-templates select="." mode="table_of_contents_overview" />
                        <xsl:apply-templates select="." mode="table_of_contents_diagrams" />
                        <xsl:apply-templates select="." mode="table_of_contents_gui" />
                        <xsl:apply-templates select="." mode="table_of_contents_interfaces" />
                        <xsl:apply-templates select="." mode="table_of_contents_classes" />
                    </ul>
                </xsl:if>
            </li>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="view">
        <xsl:choose>
            <xsl:when test="@id"><h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="name" /></h4></xsl:when>
            <xsl:otherwise><h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="name" /></h4></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" class="indent">
            <xsl:choose>
                <xsl:when test="description and not(diagrams) and not(gui) and not(classes)">
                    <xsl:apply-templates select="description" mode="onlyDescription" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="description" />
                    <xsl:apply-templates select="." mode="overview" />
                    <xsl:apply-templates select="diagrams" />
                    <xsl:apply-templates select="gui" />
                    <xsl:apply-templates select="classes" />
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>

    <xsl:template match="view" mode="name">
        <xsl:choose>
            <xsl:when test="@name">View : <xsl:value-of select="@name" /></xsl:when>
            <xsl:otherwise>View</xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="view/description" mode="onlyDescription">
        <xsl:apply-templates />
    </xsl:template>

    <xsl:template match="view/description">
        <h4>Description</h4>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

</xsl:stylesheet>