<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />

    <!-- communicate association -->

    <xsl:template match="communicate-association">
        <xsl:choose>
            <xsl:when test="@id">
                <tr id="{@id}">
                    <td><xsl:value-of select="position()" /></td>
                    <td><xsl:apply-templates select="." mode="innerContent" /></td>
                </tr>
            </xsl:when>
            <xsl:otherwise>
                <tr>
                    <td><xsl:value-of select="position()" /></td>
                    <td><xsl:apply-templates select="." mode="innerContent" /></td>
                </tr>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="actor/communicate-association | actor/communicate-associations/communicate-association" mode="innerContent">
        <!-- {cardinality-of-actor} ({time-unit-constraint-for-actor}) {actor} in role of {role-of actor} interacts with {cardinality-of-use-case} ({constraint}) "{use-case}" in role of {role-of-use-case} {navigability} -->
        <xsl:value-of select="@cardinality-of-actor" />
        <xsl:value-of select="' '" />
        <xsl:if test="@actor">
            <xsl:choose>
                <xsl:when test="@reference-to-actor"><a href="#{@reference-to-actor}"  onclick="expandAncestors('{@reference-to-actor}')"><xsl:value-of select="@actor" /></a></xsl:when>
                <xsl:otherwise><xsl:value-of select="@actor" /></xsl:otherwise>
            </xsl:choose>
        </xsl:if>
        <xsl:value-of select="' '" />
        <xsl:if test="@time-unit-constraint-for-actor"> during <xsl:value-of select="@time-unit-constraint-for-actor" /> </xsl:if>
        <xsl:value-of select="' '" />
        <xsl:if test="@role-of-actor"> in role of <xsl:value-of select="@role-of-actor" /> </xsl:if>
        <xsl:value-of select="' '" />
        <xsl:choose>
            <xsl:when test="@name"><xsl:value-of select="@name" /></xsl:when>
            <xsl:otherwise> interacts with </xsl:otherwise>
        </xsl:choose>
        <xsl:value-of select="' '" />
        <xsl:value-of select="@cardinality-of-use-case" />
        <xsl:value-of select="' '" />
        <xsl:choose>
            <xsl:when test="@use-case">
                <xsl:choose>
                    <xsl:when test="@reference-to-use-case"><a href="#{@reference-to-use-case}"  onclick="expandAncestors('{@reference-to-use-case}')"><xsl:value-of select="@use-case" /></a></xsl:when>
                    <xsl:otherwise><xsl:value-of select="@use-case" /></xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise> { Warning : the use case is not defined } </xsl:otherwise>
        </xsl:choose>
        <xsl:value-of select="' '" />
        <xsl:if test="@time-unit-constraint-for-use-case"> during <xsl:value-of select="@time-unit-constraint-for-use-case" /> </xsl:if>
        <xsl:value-of select="' '" />
        <xsl:if test="@role-of-use-case"> in role of <xsl:value-of select="@role-of-use-case" /></xsl:if>
        <xsl:value-of select="' '" />
        <xsl:choose>
            <xsl:when test="@navigability = 'straight'"> only in the direction of the transmission </xsl:when>
            <xsl:when test="@navigability = 'both'"> with navigability in both directions </xsl:when>
        </xsl:choose>
        <xsl:value-of select="' '" />
        <xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
    </xsl:template>

    <xsl:template match="use-case/communicate-association | segment/communicate-association | declaration/communicate-associations/communicate-association" mode="innerContent">
        <!-- {use-case} in role of {role-of-use-case} communicates with {actor} in role of {role-of actor} -->
        <xsl:value-of select="@cardinality-of-use-case" />
        <xsl:value-of select="' '" />
        <xsl:if test="@use-case">
            <xsl:choose>
                <xsl:when test="@reference-to-use-case"><a href="#{@reference-to-use-case}"  onclick="expandAncestors('{@reference-to-use-case}')"><xsl:value-of select="@use-case" /></a></xsl:when>
                <xsl:otherwise><xsl:value-of select="@use-case" /></xsl:otherwise>
            </xsl:choose>
        </xsl:if>
        <xsl:value-of select="' '" />
        <xsl:if test="@time-unit-constraint-for-use-case"> during <xsl:value-of select="@time-unit-constraint-for-use-case" /> </xsl:if>
        <xsl:value-of select="' '" />
        <xsl:if test="@role-of-use-case"> in role of <xsl:value-of select="@role-of-use-case" /></xsl:if>
        <xsl:value-of select="' '" />
        <xsl:choose>
            <xsl:when test="@name"><xsl:value-of select="@name" /></xsl:when>
            <xsl:otherwise> communicates with </xsl:otherwise>
        </xsl:choose>
        <xsl:value-of select="' '" />
        <xsl:value-of select="@cardinality-of-actor" />
        <xsl:value-of select="' '" />
        <xsl:choose>
            <xsl:when test="@actor">
                <xsl:choose>
                    <xsl:when test="@reference-to-actor"><a href="#{@reference-to-actor}"  onclick="expandAncestors('{@reference-to-actor}')"><xsl:value-of select="@actor" /></a></xsl:when>
                    <xsl:otherwise><xsl:value-of select="@actor" /></xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise> { Warning : the actor is not defined } </xsl:otherwise>
        </xsl:choose>
        <xsl:value-of select="' '" />
        <xsl:if test="@time-unit-constraint-for-actor"> during <xsl:value-of select="@time-unit-constraint-for-actor" /> </xsl:if>
        <xsl:value-of select="' '" />
        <xsl:if test="@role-of-actor"> in role of <xsl:value-of select="@role-of-actor" /> </xsl:if>
        <xsl:value-of select="' '" />
        <xsl:choose>
            <xsl:when test="@navigability = 'straight'"> only in the direction of the transmission </xsl:when>
            <xsl:when test="@navigability = 'both'"> with navigability in both directions </xsl:when>
        </xsl:choose>
        <xsl:value-of select="' '" />
        <xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
    </xsl:template>

</xsl:stylesheet>