<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />

	<!-- shared functions -->
	
	<xsl:template match="function | test-procedure | constructor | destructor | method | operator | thread" mode="shared_pools">
		<xsl:param name="id" required="yes" />
		<xsl:param name="reference" required="yes" />
		<xsl:choose>
			<xsl:when test="$id">
				<li id="{$id}"><a href="#{$reference}"  onclick="expandAncestors('{$reference}')"><xsl:apply-templates select="." mode="signature" /></a></li>
			</xsl:when>
			<xsl:otherwise>
				<li><a href="#{$reference}"  onclick="expandAncestors('{$reference}')"><xsl:apply-templates select="." mode="signature" /></a></li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- signature -->
	
	<xsl:template match="function" mode="signature">
		<xsl:choose>
			<xsl:when test="returns"> function </xsl:when>
			<xsl:otherwise> procedure </xsl:otherwise>
		</xsl:choose>
		<xsl:value-of select="@name" />
		<xsl:apply-templates select="parameters" mode="header" />
		<xsl:apply-templates select="returns" mode="header" />
		<xsl:apply-templates select="parameterized-types" mode="header" />
		<xsl:apply-templates select="throws" mode="header" />
	</xsl:template>

	
	<xsl:template match="test-procedure" mode="signature">
		test procedure 
		<xsl:value-of select="@name" />
		<xsl:apply-templates select="parameters" mode="header" />
		<xsl:apply-templates select="parameterized-types" mode="header" />
		<xsl:apply-templates select="throws" mode="header" />
	</xsl:template>		
	
	<xsl:template match="constructor" mode="signature">
		constructor
		<xsl:if test="@name">
			<xsl:value-of select="@name" />
		</xsl:if>
		<xsl:apply-templates select="parameters" mode="header" />
		<xsl:apply-templates select="parameterized-types" mode="header" />
		<xsl:apply-templates select="throws" mode="header" />
	</xsl:template>
	
	<xsl:template match="destructor" mode="signature">
		destructor
		<xsl:if test="@name">
			<xsl:value-of select="@name" />
		</xsl:if>
		<xsl:apply-templates select="parameters" mode="header" />
		<xsl:apply-templates select="parameterized-types" mode="header" />
		<xsl:apply-templates select="throws" mode="header" />
	</xsl:template>
	
	<xsl:template match="method" mode="signature">
		method 
		<xsl:value-of select="@name" />
		<xsl:apply-templates select="parameters" mode="header" />
		<xsl:apply-templates select="returns" mode="header" />
		<xsl:apply-templates select="parameterized-types" mode="header" />
		<xsl:apply-templates select="throws" mode="header" />
	</xsl:template>
	
	<xsl:template match="operator" mode="signature">
		operator 
		<xsl:value-of select="@signature" />
		<xsl:if test="@name">
			named as 
			<xsl:value-of select="@name" />
		</xsl:if>
		<xsl:if test="@priority">
			with priority 
			<xsl:value-of select="@priority" />
		</xsl:if>
		<xsl:apply-templates select="parameters" mode="header" />
		<xsl:apply-templates select="returns" mode="header" />
		<xsl:apply-templates select="parameterized-types" mode="header" />
		<xsl:apply-templates select="throws" mode="header" />
	</xsl:template>
	
	<xsl:template match="thread" mode="signature">
		thread 
		<xsl:value-of select="@name" />
	</xsl:template>

</xsl:stylesheet>
