<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
	<!-- shared classes -->
	
	<xsl:template match="interface | class" mode="shared_pools">
		<xsl:param name="id" required="yes" />
		<xsl:param name="reference" required="yes" />	
		<xsl:choose>
			<xsl:when test="$id">
				<li id="{$id}"><a href="#{$reference}" onclick="expandAncestors('{$reference}')"><xsl:apply-templates select="." mode="signature" /></a></li>
			</xsl:when>
			<xsl:otherwise>
				<li><a href="#{$reference}" onclick="expandAncestors('{$reference}')"><xsl:apply-templates select="." mode="signature" /></a></li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>		
	
	<xsl:template match="interface" mode="signature">
		interface
		<xsl:if test="@package"> <xsl:value-of select="@package" /> :: </xsl:if>
		<xsl:value-of select="@name" />
		<xsl:apply-templates select="." mode="header_implements" />
		<xsl:apply-templates select="parameterized-types" mode="header" />
	</xsl:template>
	
	<xsl:template match="class" mode="signature">
		class 
		<xsl:if test="@package"> <xsl:value-of select="@package" /> :: </xsl:if>
		<xsl:value-of select="@name" />
		<xsl:apply-templates select="." mode="header_extends" />
		<xsl:apply-templates select="." mode="header_implements" />
		<xsl:apply-templates select="parameterized-types" mode="header" />
	</xsl:template>	
	
	<!-- shared types -->
	
	<xsl:template match="type | primitive | file | array | list | queue | stack | set | hashtable | interval | enumeration | tree" mode="shared_pools">
		<xsl:param name="id" required="yes" />
		<xsl:param name="reference" required="yes" />	
		<xsl:choose>
			<xsl:when test="$id">
				<li id="{$id}"><a href="#{$reference}"  onclick="expandAncestors('{$reference}')"><xsl:apply-templates select="." mode="content" /></a></li>
			</xsl:when>
			<xsl:otherwise>
				<li><a href="#{$reference}"  onclick="expandAncestors('{$reference}')"><xsl:apply-templates select="." mode="content" /></a></li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>	
	
	<xsl:template match="record" mode="shared_pools">
		<xsl:param name="id" required="yes" />
		<xsl:param name="reference" required="yes" />	
		<xsl:choose>
			<xsl:when test="@id">
				<li id="{@id}"><a href="#{$reference}"  onclick="expandAncestors('{$reference}')"><xsl:apply-templates select="." mode="content" /></a></li>
				<li id="{generate-id(.)}-end"><a href="#{$reference}"  onclick="expandAncestors('{$reference}')">end record</a></li>
			</xsl:when>
			<xsl:otherwise>
				<li><a href="#{$reference}"  onclick="expandAncestors('{$reference}')"><xsl:apply-templates select="." mode="content" /></a></li>
				<li id="{generate-id(.)}-end"><a href="#{$reference}"  onclick="expandAncestors('{$reference}')">end record</a></li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>