<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions"
                xmlns:Xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" encoding="UTF-8" />

    <!-- capsule -->

    <!-- solution, implementation, model -->

    <xsl:template match="solution | implementation | model" mode="table_of_contents_capsules">
        <xsl:if test="capsules/capsule">
            <li>
                <xsl:choose>
                    <xsl:when test="count(capsules/capsule) = 1"><a href="#{generate-id(capsules)}">Capsule</a></xsl:when>
                    <xsl:otherwise><a href="#{generate-id(capsules)}">Capsules</a></xsl:otherwise>
                </xsl:choose>
                <ul>
                    <xsl:for-each select="capsules/capsule">
                        <li>
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="solution/capsules | implementation/capsules | model/capsules">
        <h2 id="{generate-id(.)}">
            <xsl:choose>
                <xsl:when test="count(capsule) = 1">Capsule</xsl:when>
                <xsl:otherwise>Capsules</xsl:otherwise>
            </xsl:choose>
        </h2>
        <xsl:apply-templates />
    </xsl:template>

    <xsl:template match="architecture/capsules/capsule | solution/capsules/capsule | implementation/capsules/capsule | model/capsules/capsule">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Capsule : <xsl:value-of select="@name" /></h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Capsule : <xsl:value-of select="@name" /></h3></xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="." mode="content" />
    </xsl:template>

    <!-- architecture, package, capsule -->

    <xsl:template match="architecture | package | capsule | realization" mode="table_of_contents_capsules">
        <xsl:if test="capsules/capsule">
            <li>
                <xsl:choose>
                    <xsl:when test="count(capsules/capsule) = 1">Capsule</xsl:when>
                    <xsl:otherwise>Capsules</xsl:otherwise>
                </xsl:choose>
                <ul>
                    <xsl:for-each select="capsules/capsule">
                        <li>
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="architecture/capsules | package/capsules | realization/capsules | capsule/capsules">
        <xsl:apply-templates select="capsule" />
    </xsl:template>

    <xsl:template match="capsules">
        <h4 onclick="toggleGroup('{generate-id(.)}')">
            <xsl:choose>
                <xsl:when test="count(capsule) = 1">Capsule</xsl:when>
                <xsl:otherwise>Capsules</xsl:otherwise>
            </xsl:choose>
        </h4>
        <div class="indent"  id="{generate-id(.)}" style="collapsed">
            <xsl:apply-templates select="capsule" />
        </div>
    </xsl:template>

    <xsl:template match="capsule">
        <xsl:choose>
            <xsl:when test="@id"><h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Capsule : <xsl:value-of select="@name" /></h4></xsl:when>
            <xsl:otherwise><h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Capsule : <xsl:value-of select="@name" /></h4></xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="." mode="content" />
    </xsl:template>

    <!-- content -->

    <xsl:template match="capsule" mode="content">
        <div id="{generate-id(.)}" class="indent" style="display:none">
            <xsl:choose>
                <xsl:when test="description and not(specification) and not(port) and not(realizes) and not(diagrams) and not(classes) and not(types) and not(capsules)">
                    <xsl:apply-templates select="description" mode="onlyDescription" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="description" />
                    <xsl:apply-templates select="." mode="table_of_contents" />
                    <xsl:apply-templates select="." mode="overview" />
                    <xsl:apply-templates select="specification" />
                    <xsl:apply-templates select="." mode="ports" />
                    <xsl:apply-templates select="." mode="realizes" />
                    <xsl:apply-templates select="diagrams" />
                    <xsl:apply-templates select="capsules" />
                    <xsl:apply-templates select="classes" />
                    <xsl:apply-templates select="types" />
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>

    <xsl:template match="capsule/description" mode="onlyDescription">
        <xsl:apply-templates />
    </xsl:template>

    <xsl:template match="capsule/description">
        <h4>Description</h4>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="capsule" mode="table_of_contents">
        <xsl:if test="specification or diagrams or classes or capsules or types">
            <h4>Table of contents</h4>
            <ul class="contents">
                <xsl:apply-templates select="." mode="table_of_contents_overview" />
                <xsl:apply-templates select="." mode="table_of_contents_specification" />
                <xsl:apply-templates select="." mode="table_of_contents_diagrams" />
                <xsl:apply-templates select="." mode="table_of_contents_capsules" />
                <xsl:apply-templates select="." mode="table_of_contents_interfaces" />
                <xsl:apply-templates select="." mode="table_of_contents_classes" />
                <xsl:apply-templates select="." mode="table_of_contents_types" />
            </ul>
        </xsl:if>
    </xsl:template>

    <xsl:template match="capsule" mode="realizes">
        <xsl:if test="realizes">
            <h4 onclick="toggleTag('{generate-id(.)}-realizes')">Realizes</h4>
            <ul id="{generate-id(.)}-realizes" class="attributes">
                <xsl:apply-templates select="realizes" />
            </ul>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>
