<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />

	<!-- classes -->

    <!-- solution, implementation, model -->

	<xsl:template match="solution | implementation | model" mode="table_of_contents_interfaces">
		<xsl:if test="classes/interface">
			<li>
                <xsl:choose>
                    <xsl:when test="count(classes/interface) > 1"><a href="#{generate-id(classes)}">Interfaces</a></xsl:when>
                    <xsl:when test="count(classes/interface) = 1"><a href="#{generate-id(classes)}">Interface</a></xsl:when>
                </xsl:choose>
				<ul>
					<xsl:for-each select="classes/interface">
						<li>
							<xsl:choose>
								<xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
								<xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
							</xsl:choose>
						</li>
					</xsl:for-each>
				</ul>
			</li>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="solution | implementation | model" mode="table_of_contents_classes">
		<xsl:if test="classes/class">
			<li>
                <xsl:choose>
                    <xsl:when test="count(classes/class) > 1"><a href="#{generate-id(classes)}">Classes</a></xsl:when>
                    <xsl:when test="count(classes/class) = 1"><a href="#{generate-id(classes)}">Class</a></xsl:when>
                </xsl:choose>
				<ul>
					<xsl:for-each select="classes/class">
						<li>
							<xsl:choose>
								<xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
								<xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
							</xsl:choose>
						</li>
					</xsl:for-each>
				</ul>
			</li>
		</xsl:if>
	</xsl:template>

	<xsl:template match="solution/classes | implementation/classes | model/classes">
		<h2 id="{generate-id(.)}">
            <xsl:choose>
                <xsl:when test="not(class) and count(interface) > 1">Interfaces</xsl:when>
                <xsl:when test="not(class) and count(interface) = 1">Interface</xsl:when>
                <xsl:when test="not(interface) and count(class) = 1">Class</xsl:when>
                <xsl:otherwise>Classes</xsl:otherwise>
            </xsl:choose>
        </h2>
		<xsl:apply-templates />
	</xsl:template>

	<xsl:template match="solution/classes/interface | implementation/classes/interface | model/classes/interface | model/use-case/classes/interface | architecture/classes/interface">
		<xsl:choose>
			<xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="interface_header" /></h3></xsl:when>
			<xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="interface_header" /></h3></xsl:otherwise>
		</xsl:choose>		
		<xsl:apply-templates select="." mode="content" />
	</xsl:template>

	<xsl:template match="solution/classes/class | implementation/classes/class | model/classes/class | model/use-case/classes/class | architecture/classes/class">
		<xsl:choose>
			<xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="class_header" /></h3></xsl:when>
			<xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="class_header" /></h3></xsl:otherwise>
		</xsl:choose>		
		<xsl:apply-templates select="." mode="content" />
	</xsl:template>

    <!-- architecture, level of package -->

    <xsl:template match="architecture | package | realization | capsule | common-view | view" mode="table_of_contents_interfaces">
        <xsl:if test="classes/interface">
            <li>
                <xsl:choose>
                    <xsl:when test="count(classes/interface) > 1">Interfaces</xsl:when>
                    <xsl:when test="count(classes/interface) = 1">Interface</xsl:when>
                </xsl:choose>
                <ul>
                    <xsl:for-each select="classes/interface">
                        <li>
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="architecture | package | realization | capsule | common-view | view" mode="table_of_contents_classes">
        <xsl:if test="classes/class">
            <li>
                <xsl:choose>
                    <xsl:when test="count(classes/class) > 1">Classes</xsl:when>
                    <xsl:when test="count(classes/class) = 1">Class</xsl:when>
                </xsl:choose>
                <ul>
                    <xsl:for-each select="classes/class">
                        <li>
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="architecture/classes | package/classes | realization/classes | capsule/classes | common-view/classes | view/classes">
        <xsl:apply-templates />
    </xsl:template>

</xsl:stylesheet>
