<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" />

    <!-- port -->

    <xsl:template match="capsule" mode="ports">
        <xsl:if test="port">
            <xsl:choose>
                <xsl:when test="count(port) = 1">
                    <xsl:apply-templates select="port" />
                </xsl:when>
                <xsl:otherwise>
                    <h4 onclick="toggleTag('{generate-id(.)}-ports')">Ports</h4>
                    <div id="{generate-id(.)}-ports" class="indent">
                        <xsl:apply-templates select="port" />
                    </div>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>

    <xsl:template match="port">
        <h4 onclick="toggleTag('{generate-id(.)}')">
            <xsl:choose>
                <xsl:when test="@cardinality or @visibility or @name">
                    Port :
                    <xsl:value-of select="@cardinality" />
                    <xsl:value-of select="' '" />
                    <xsl:value-of select="@visibility" />
                    <xsl:value-of select="' '" />
                    <xsl:value-of select="@name" />
                </xsl:when>
                <xsl:otherwise>Port</xsl:otherwise>
            </xsl:choose>
        </h4>
        <div id="{generate-id(.)}" class="indent">
            <xsl:choose>
                <xsl:when test="description and not(provided) and not(required)">
                    <xsl:apply-templates select="description" mode="onlyDescription" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="description" />
                    <xsl:apply-templates select="." mode="provided" />
                    <xsl:apply-templates select="." mode="required" />
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>

    <xsl:template match="port/description" mode="onlyDescription">
        <xsl:apply-templates />
    </xsl:template>

    <xsl:template match="port/description">
        <h4>Description</h4>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="port" mode="provided">
        <xsl:if test="provided">
            <h4 onclick="toggleTag('{generate-id(.)}-provided')">
                <xsl:choose>
                    <xsl:when test="count(provided) = 1">Provided interface</xsl:when>
                    <xsl:otherwise>Provided interfaces</xsl:otherwise>
                </xsl:choose>
            </h4>
            <ul id="{generate-id(.)}-provided" class="attributes">
                <xsl:apply-templates select="provided" />
            </ul>
        </xsl:if>
    </xsl:template>

    <xsl:template match="port" mode="required">
        <xsl:if test="required">
            <h4 onclick="toggleTag('{generate-id(.)}-required')">
                <xsl:choose>
                    <xsl:when test="count(required) = 1">Required interface</xsl:when>
                    <xsl:otherwise>Required interfaces</xsl:otherwise>
                </xsl:choose>
            </h4>
            <ul id="{generate-id(.)}-required" class="attributes">
                <xsl:apply-templates select="required" />
            </ul>
        </xsl:if>
    </xsl:template>

    <xsl:template match="provided | required">
        <li>
            <xsl:choose>
                <xsl:when test="@reference and @page and $out = 'file'">
                    <a href="{@page}#{@reference}"><xsl:value-of select="@interface" /></a>
                </xsl:when>
                <xsl:when test="@reference and @document and $out = 'memory'">
                    <a href="{@document}#{@reference}"><xsl:value-of select="@interface" /></a>
                </xsl:when>
                <xsl:when test="@reference">
                    <a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@interface" /></a>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="@interface" />
                </xsl:otherwise>
            </xsl:choose>
            <xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
        </li>
    </xsl:template>

</xsl:stylesheet>