<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />

	<!-- protocol -->
	
	<xsl:template match="class-protocol">
		<h4 onclick="toggleTag('{generate-id(.)}')">Class protocol</h4>
		<div id="{generate-id(.)}" class="indent">
			<xsl:apply-templates select="attributes" />
			<xsl:apply-templates select="operations" />
			<xsl:apply-templates select="static" />
		</div>
	</xsl:template>
	
	<xsl:template match="instance-protocol">
		<h4 onclick="toggleTag('{generate-id(.)}')">Instance protocol</h4>
		<div id="{generate-id(.)}" class="indent">
			<xsl:apply-templates select="attributes" />
			<xsl:apply-templates select="operations" />
		</div>
	</xsl:template>
	
	<xsl:template match="attributes">
		<h4>Attributes</h4>
		<div class="indent">
            <xsl:apply-templates select="capsules" />
			<xsl:apply-templates select="classes" />
			<xsl:apply-templates select="types" />
			<xsl:apply-templates select="constants" />
			<xsl:apply-templates select="data" />
			<xsl:apply-templates select="enumeration-constant-elements" />
			<xsl:apply-templates select="elements" />
			<xsl:apply-templates select="properties" />
			<xsl:apply-templates select="signals" />
			<xsl:apply-templates select="channels" />
			<xsl:apply-templates select="associations" />
			<xsl:apply-templates select="dependencies" />
		</div>
	</xsl:template>
	
	<xsl:template match="operations">
		<h4>Operations</h4>
		<div class="indent">
			<xsl:if test="constructor">
				<xsl:choose>
					<xsl:when test="count(constructor) > 1"><h4 onclick="toggleGroup('{generate-id(.)}-constructors')">Constructors</h4></xsl:when>
					<xsl:otherwise><h4 onclick="toggleGroup('{generate-id(.)}-constructors')">Constructor</h4></xsl:otherwise>
				</xsl:choose>
				<div id="{generate-id(.)}-constructors" class="indent" style="collapsed">
					<xsl:apply-templates select="constructor" />
				</div>
			</xsl:if>
			<xsl:if test="destructor">
				<xsl:choose>
					<xsl:when test="count(destructor) > 1"><h4 onclick="toggleGroup('{generate-id(.)}-destructors')">Destructors</h4></xsl:when>
					<xsl:otherwise><h4 onclick="toggleGroup('{generate-id(.)}-destructors')">Destructor</h4></xsl:otherwise>
				</xsl:choose>
				<div id="{generate-id(.)}-destructors" class="indent" style="collapsed">
					<xsl:apply-templates select="destructor" />
				</div>
			</xsl:if>
			<xsl:if test="method">
				<xsl:choose>
					<xsl:when test="count(method) > 1"><h4 onclick="toggleGroup('{generate-id(.)}-methods')">Methods</h4></xsl:when>
					<xsl:otherwise><h4 onclick="toggleGroup('{generate-id(.)}-methods')">Method</h4></xsl:otherwise>
				</xsl:choose>
				<div id="{generate-id(.)}-methods" class="indent" style="collapsed">
					<xsl:apply-templates select="method" />
				</div>
			</xsl:if>
			<xsl:if test="operator">
				<xsl:choose>
					<xsl:when test="count(operator) > 1"><h4 onclick="toggleGroup('{generate-id(.)}-operators')">Operators</h4></xsl:when>
					<xsl:otherwise><h4 onclick="toggleGroup('{generate-id(.)}-operators')">Operator</h4></xsl:otherwise>
				</xsl:choose>
				<div id="{generate-id(.)}-operators" class="indent" style="collapsed">
					<xsl:apply-templates select="operator" />
				</div>
			</xsl:if>
			<xsl:if test="thread">
				<xsl:choose>
					<xsl:when test="count(method) > 1"><h4 onclick="toggleGroup('{generate-id(.)}-threads')">Threads</h4></xsl:when>
					<xsl:otherwise><h4 onclick="toggleGroup('{generate-id(.)}-threads')">Thread</h4></xsl:otherwise>
				</xsl:choose>
				<div id="{generate-id(.)}-threads" class="indent" style="collapsed">
					<xsl:apply-templates select="thread" />
				</div>
			</xsl:if>
			<xsl:apply-templates select="group" />
		</div>
	</xsl:template>
	
	<xsl:template match="group">
		<xsl:choose>
			<xsl:when test="@id">
				<h4 id="{@id}" onclick="toggleGroup('{generate-id(.)}')">Group of operations for using on purpose to <xsl:value-of select="@purpose" /></h4>
			</xsl:when>
			<xsl:otherwise>
				<h4 onclick="toggleGroup('{generate-id(.)}')">Group of operations for using on purpose to <xsl:value-of select="@purpose" /></h4>
			</xsl:otherwise>
		</xsl:choose>
		<div id="{generate-id(.)}" class="indent" style="collapsed">
			<xsl:apply-templates />
		</div>
	</xsl:template>
	
</xsl:stylesheet>