<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
	<!-- special functions -->
	
	<xsl:template match="class/class-protocol/static | feature/class-protocol/static">
		<xsl:choose>
			<xsl:when test="@id">
				<h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Static</h4>
			</xsl:when>
			<xsl:otherwise>
				<h4 onclick="toggleTag('{generate-id(.)}')">Static</h4>
			</xsl:otherwise>
		</xsl:choose>
		<div id="{generate-id(.)}" class="indent">
			<xsl:apply-templates select="description" />
            <xsl:apply-templates select="."  mode="overview" />
			<xsl:apply-templates select="specification" />
            <xsl:apply-templates select="capsules" />
			<xsl:apply-templates select="classes" />
			<xsl:apply-templates select="types" />
			<xsl:apply-templates select="constants" />
			<xsl:apply-templates select="data" />
			<xsl:apply-templates select="functions" />
            <xsl:apply-templates select="threads" />
			<xsl:apply-templates select="aspects" />
			<xsl:apply-templates select="sequences" />
			<xsl:apply-templates select="."  mode="algorithm" />
			<xsl:apply-templates select="diagrams" />
		</div>
	</xsl:template>

	<xsl:template match="set-property">
		<xsl:choose>
			<xsl:when test="@id">
				<h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')">
					Set <xsl:apply-templates select="throws" mode="header" />
					<xsl:if test="@name"> named as <xsl:value-of select="@name" /></xsl:if>
				</h4>
			</xsl:when>
			<xsl:otherwise>
				<h4 onclick="toggleTag('{generate-id(.)}')">
					Set <xsl:apply-templates select="throws" mode="header" />
					<xsl:if test="@name"> named as <xsl:value-of select="@name" /></xsl:if>
				</h4>
			</xsl:otherwise>
		</xsl:choose>
		<div id="{generate-id(.)}" class="indent">
			<xsl:apply-templates select="description" />
            <xsl:apply-templates select="."  mode="overview" />
			<xsl:apply-templates select="specification" />
			<xsl:apply-templates select="throws" />
			<xsl:apply-templates select="shared-pools" />
            <xsl:apply-templates select="contract" />
            <xsl:apply-templates select="capsules" />
			<xsl:apply-templates select="classes" />
			<xsl:apply-templates select="types" />
			<xsl:apply-templates select="constants" />
			<xsl:apply-templates select="data" />
			<xsl:apply-templates select="functions" />
            <xsl:apply-templates select="threads" />
			<xsl:apply-templates select="aspects" />
			<xsl:apply-templates select="sequences" />
			<xsl:apply-templates select="."  mode="algorithm" />
			<xsl:apply-templates select="diagrams" />
		</div>
	</xsl:template>
	
	<xsl:template match="get-property">
		<xsl:choose>
			<xsl:when test="@id">
				<h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')">
					Get <xsl:apply-templates select="throws" mode="header" />
					<xsl:if test="@name"> named as <xsl:value-of select="@name" /></xsl:if>
				</h4>
			</xsl:when>
			<xsl:otherwise>
				<h4 onclick="toggleTag('{generate-id(.)}')">
					Get <xsl:apply-templates select="throws" mode="header" />
					<xsl:if test="@name"> named as <xsl:value-of select="@name" /></xsl:if>
				</h4>
			</xsl:otherwise>
		</xsl:choose>
		<div id="{generate-id(.)}" class="indent">
			<xsl:apply-templates select="description" />
            <xsl:apply-templates select="."  mode="overview" />
			<xsl:apply-templates select="specification" />
			<xsl:apply-templates select="throws" />
			<xsl:apply-templates select="shared-pools" />
            <xsl:apply-templates select="contract" />
            <xsl:apply-templates select="capsules" />
			<xsl:apply-templates select="classes" />
			<xsl:apply-templates select="types" />
			<xsl:apply-templates select="constants" />
			<xsl:apply-templates select="data" />
			<xsl:apply-templates select="functions" />
            <xsl:apply-templates select="threads" />
			<xsl:apply-templates select="aspects" />
			<xsl:apply-templates select="sequences" />
			<xsl:apply-templates select="."  mode="algorithm" />
			<xsl:apply-templates select="diagrams" />
		</div>
	</xsl:template>
	
	<!-- content -->
	
	<xsl:template match="static/description | set-property/description | get-property/description">
		<h4>Description</h4>
		<div class="indent"><xsl:apply-templates /></div>
	</xsl:template>
	
</xsl:stylesheet>