<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
	<!-- diagrams -->

    <!-- solution, implementation, model -->

	<xsl:template match="solution | implementation | model | catalog" mode="table_of_contents_diagrams">
		<xsl:if test="diagrams">
			<li>
                <xsl:choose>
                    <xsl:when test="count(diagrams/diagram) > 1"><a href="#{generate-id(diagrams)}">Diagrams</a></xsl:when>
                    <xsl:when test="count(diagrams/diagram) = 1"><a href="#{generate-id(diagrams)}">Diagram</a></xsl:when>
                </xsl:choose>
				<ul>
					<xsl:for-each select="diagrams/diagram">
						<li>
							<xsl:choose>
								<xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
								<xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
							</xsl:choose>
						</li>
					</xsl:for-each>
				</ul>
			</li>
		</xsl:if>
	</xsl:template>

    <xsl:template match="solution/diagrams | implementation/diagrams | model/diagrams | catalog/diagrams">
        <xsl:choose>
            <xsl:when test="count(diagram) > 1"><h2 id="{generate-id(.)}">Diagrams</h2></xsl:when>
            <xsl:when test="count(diagram) = 1"><h2 id="{generate-id(.)}">Diagram</h2></xsl:when>
        </xsl:choose>
        <xsl:apply-templates select="diagram" />
    </xsl:template>

    <xsl:template match="architecture/diagrams/diagram | solution/diagrams/diagram | implementation/diagrams/diagram | model/diagrams/diagram | model/use-case/declaration/diagrams/diagram | catalog/diagrams/diagram">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:value-of select="@name" /></h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:value-of select="@name" /></h3></xsl:otherwise>
        </xsl:choose>
        <img id="{generate-id(.)}" alt="{@name}" src="{@image}" />
    </xsl:template>
  
    <!-- architecture, level of package -->
  
	<xsl:template match="architecture | package | declaration | realization | capsule | common-view | view" mode="table_of_contents_diagrams">
		<xsl:if test="diagrams">
			<li>
                <xsl:choose>
                    <xsl:when test="count(diagrams/diagram) > 1">Diagrams</xsl:when>
                    <xsl:when test="count(diagrams/diagram) = 1">Diagram</xsl:when>
                </xsl:choose>
				<ul>
					<xsl:for-each select="diagrams/diagram">
						<li>
							<xsl:choose>
								<xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
								<xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
							</xsl:choose>
						</li>
					</xsl:for-each>
				</ul>
			</li>
		</xsl:if>
	</xsl:template>

	<xsl:template match="architecture/diagrams | package/diagrams | declaration/diagrams | realization/diagrams">
		<xsl:apply-templates select="diagram" />
	</xsl:template>

    <xsl:template match="package/diagrams/diagram | package/use-case/declration/diagrams/diagram | use-case/use-case/declaration/diagrams/diagram | segment/declaration/diagrams/diagram | realization/diagrams/diagram">
        <xsl:choose>
            <xsl:when test="@id"><h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Diagram : <xsl:value-of select="@name" /></h4></xsl:when>
            <xsl:otherwise><h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Diagram : <xsl:value-of select="@name" /></h4></xsl:otherwise>
        </xsl:choose>
        <img id="{generate-id(.)}" alt="{@name}" src="{@image}" />
    </xsl:template>

    <!-- inner diagrams -->

    <!-- expanded diagram -->

    <xsl:template match="interface/diagrams | class/diagrams | feature/diagrams | capsule/diagrams | common-view/diagrams | view/diagrams">
        <xsl:apply-templates select="diagram" />
    </xsl:template>

    <xsl:template match="interface/diagrams/diagram | class/diagrams/diagram | feature/diagrams/diagram | capsule/diagrams/diagram | common-view/diagrams/diagram | view/diagrams/diagram">
        <xsl:choose>
            <xsl:when test="@id"><h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Diagram : <xsl:value-of select="@name" /></h4></xsl:when>
            <xsl:otherwise><h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Diagram : <xsl:value-of select="@name" /></h4></xsl:otherwise>
        </xsl:choose>
        <img id="{generate-id(.)}" alt="{@name}" src="{@image}" />
    </xsl:template>

    <!-- collapsed diagrams -->

    <xsl:template match="diagrams">
        <h4 onclick="toggleGroup('{generate-id(.)}')">Diagrams</h4>
        <div id="{generate-id(.)}" class="indent" state="collapsed">
            <xsl:apply-templates select="diagram" />
        </div>
    </xsl:template>

    <xsl:template match="diagram">
        <xsl:choose>
            <xsl:when test="@id"><h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Diagram : <xsl:value-of select="@name" /></h4></xsl:when>
            <xsl:otherwise><h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Diagram : <xsl:value-of select="@name" /></h4></xsl:otherwise>
        </xsl:choose>
        <img id="{generate-id(.)}" alt="{@name}" src="{@image}" style="display:none" />
    </xsl:template>

</xsl:stylesheet>
