<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
	<!-- function -->
	
	<!-- top level -->
	
	<xsl:template match="solution | implementation | model" mode="table_of_contents_functions">
		<xsl:if test="functions">
			<li>
                <xsl:choose>
                    <xsl:when test="count(functions/function) > 1"><a href="#{generate-id(functions)}">Functions</a></xsl:when>
                    <xsl:when test="count(functions/function) = 1"><a href="#{generate-id(functions)}">Function</a></xsl:when>
                </xsl:choose>
				<ul>
					<xsl:for-each select="functions/function">
						<li>
							<xsl:choose>
								<xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
								<xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
							</xsl:choose>
						</li>
					</xsl:for-each>
				</ul>
			</li>
		</xsl:if>		
	</xsl:template>

	 <xsl:template match="solution/functions | implementation/functions | model/functions">
         <xsl:choose>
             <xsl:when test="count(function) > 1"><h2 id="{generate-id(.)}">Functions</h2></xsl:when>
             <xsl:when test="count(function) = 1"><h2 id="{generate-id(.)}">Function</h2></xsl:when>
         </xsl:choose>
		 <xsl:apply-templates select="function" />
	 </xsl:template>
  
	<xsl:template match="solution/functions/function | implementation/functions/function | model/functions/function">
		<xsl:choose>
			<xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="function_header" /></h3></xsl:when>
			<xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="function_header" /></h3></xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="." mode="content" />
	</xsl:template>

	<!-- level of package -->

	<xsl:template match="package | realization" mode="table_of_contents_functions">
		<xsl:if test="functions">
			<li>
                <xsl:choose>
                    <xsl:when test="count(functions/function) > 1">Functions</xsl:when>
                    <xsl:when test="count(functions/function) = 1">Function</xsl:when>
                </xsl:choose>
				<ul>
					<xsl:for-each select="functions/function">
						<li>
							<xsl:choose>
								<xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
								<xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
							</xsl:choose>
						</li>
					</xsl:for-each>
				</ul>
			</li>
		</xsl:if>		
	</xsl:template>

    <xsl:template match="package/functions | realization/functions">
		<xsl:apply-templates select="function" />
	</xsl:template>

</xsl:stylesheet>
