<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" />

    <!-- test procedure -->

    <!-- top level -->

    <xsl:template match="solution | implementation | model" mode="table_of_contents_test_procedures">
        <xsl:if test="test-procedures">
            <li>
                <xsl:choose>
                    <xsl:when test="count(test-procedures/test-procedure) > 1"><a href="#{generate-id(test-procedures)}">Test procedures</a></xsl:when>
                    <xsl:when test="count(test-procedures/test-procedure) = 1"><a href="#{generate-id(test-procedures)}">Test procedure</a></xsl:when>
                </xsl:choose>
                <ul>
                    <xsl:for-each select="test-procedures/test-procedure">
                        <li>
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="solution/test-procedures | implementation/test-procedures | model/test-procedures">
        <xsl:choose>
            <xsl:when test="count(test-procedure) > 1"><h2 id="{generate-id(.)}">Test procedures</h2></xsl:when>
            <xsl:when test="count(test-procedure) = 1"><h2 id="{generate-id(.)}">Test procedure</h2></xsl:when>
        </xsl:choose>
        <xsl:apply-templates select="test-procedure" />
    </xsl:template>

    <xsl:template match="solution/test-procedures/test-procedure | implementation/test-procedures/test-procedure | model/test-procedures/test-procedure">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="test_procedure_header" /></h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="test_procedure_header" /></h3></xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="." mode="content" />
    </xsl:template>

    <!-- level of package -->

    <xsl:template match="package | realization" mode="table_of_contents_test_procedures">
        <xsl:if test="test-procedures">
            <li>
                <xsl:choose>
                    <xsl:when test="count(test-procedures/test-procedure) > 1">Test procedures</xsl:when>
                    <xsl:when test="count(test-procedures/test-procedure) = 1">Test procedure</xsl:when>
                </xsl:choose>
                <ul>
                    <xsl:for-each select="test-procedures/test-procedure">
                        <li>
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="package/test-procedures | realization/test-procedures">
        <xsl:apply-templates select="test-procedure" />
    </xsl:template>

</xsl:stylesheet>