<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8"/>
	
	<!-- modules -->
	
	<xsl:template match="solution | analysis | model | implementation | catalog" mode="table_of_contents_modules">
		<xsl:if test="modules">
			<li><a href="#{generate-id(modules)}">Modules</a></li>
		</xsl:if>
	</xsl:template>

	<xsl:template match="modules">
		<h3 id="{generate-id(.)}" onclick="toggleModules()">Modules</h3>
		<ul id="modulesList" class="modules" state="collapsed">
			<xsl:apply-templates />
		</ul>
	</xsl:template>
	
	<xsl:template match="module-package">
		<li><a href="javascript:toggleTag('{generate-id(.)}')" title="{@name} package"><xsl:value-of select="@name" /></a>
			<ul id="{generate-id(.)}" class="module-package" style="display:none">
				<xsl:apply-templates />
			</ul>
		</li>
	</xsl:template>
	
</xsl:stylesheet>
