<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" />

    <!-- capsule overview -->

    <xsl:template match="capsule" mode="table_of_contents_overview">
        <xsl:if test="classes or capsules">
            <li><a href="#{generate-id(.)}-overview-header"  onclick="expandAncestors('{generate-id(.)}-overview-header')">Overview</a></li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="capsule" mode="overview">
        <xsl:if test="classes or capsules">
            <h4 id="{generate-id(.)}-overview-header"  onclick="toggleTag('{generate-id(.)}-overview')">Overview</h4>
            <div id="{generate-id(.)}-overview" class="indent" style="display:none">
                <xsl:apply-templates select="." mode="overview_capsules" />
                <xsl:apply-templates select="." mode="overview_classes" />
            </div>
        </xsl:if>
    </xsl:template>

    <!-- class overview -->

    <xsl:template match="class" mode="overview_capsules">
        <!-- CD -->
        <xsl:variable name="canPerformCD1" select="class-protocol/attributes/capsules" />
        <xsl:variable name="canPerformCD2" select="instance-protocol/attributes/capsules" />
        <xsl:variable name="canPerformCD3" select=".//feature/class-protocol/attributes/capsules" />
        <xsl:variable name="canPerformCD4" select=".//feature/instance-protocol/attributes/capsules" />
        <xsl:variable name="canPerformCD" select="$canPerformCD1 or $canPerformCD2 or $canPerformCD3 or $canPerformCD4" />
        <xsl:if test="$canPerformCD">
            <table class="overview">
                <caption>Capsule - Description</caption>
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Description</th>
                    </tr>
                </thead>
                <tbody>
                    <xsl:apply-templates select="feature" mode="capd" />
                    <xsl:apply-templates select="class-protocol/attributes/capsules/capsule" mode="cd" />
                    <xsl:apply-templates select="instance-protocol/attributes/capsules/capsule" mode="cd" />
                </tbody>
            </table>
        </xsl:if>
    </xsl:template>

    <xsl:template match="feature" mode="capd">
        <xsl:apply-templates select="feature" mode="capd" />
        <xsl:apply-templates select="class-protocol/attributes/capsules/capsule" mode="cd" />
        <xsl:apply-templates select="instance-protocol/attributes/capsules/capsule" mode="cd" />
    </xsl:template>

</xsl:stylesheet>