<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- classes overview -->

    <xsl:template match="class" mode="overview_classes">
        <!-- CDA -->
        <xsl:variable name="canPerformCD1" select="class-protocol/attributes/classes" />
        <xsl:variable name="canPerformCD2" select="instance-protocol/attributes/classes" />
        <xsl:variable name="canPerformCD3" select=".//feature/class-protocol/attributes/classes" />
        <xsl:variable name="canPerformCD4" select=".//feature/instance-protocol/attributes/classes" />
        <xsl:variable name="canPerformCD" select="$canPerformCD1 or $canPerformCD2 or $canPerformCD3 or $canPerformCD4" />
        <xsl:if test="$canPerformCD">
            <table class="overview">
                <caption>Class - Description</caption>
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Description</th>
                    </tr>
                </thead>
                <tbody>
                    <xsl:apply-templates select="feature" mode="cd" />
                    <xsl:apply-templates select="class-protocol/attributes/classes/interface" mode="cd" />
                    <xsl:apply-templates select="class-protocol/attributes/classes/class" mode="cd" />
                    <xsl:apply-templates select="instance-protocol/attributes/classes/interface" mode="cd" />
                    <xsl:apply-templates select="instance-protocol/attributes/classes/class" mode="cd" />
                </tbody>
            </table>
            <table class="overview">
                <caption>Class - Responsibilities - Collaboration</caption>
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Responsibilities</th>
                        <th>Collaboration</th>
                    </tr>
                </thead>
                <tbody>
                    <xsl:apply-templates select="feature" mode="crc" />
                    <xsl:apply-templates select="class-protocol/attributes/classes/interface" mode="crc" />
                    <xsl:apply-templates select="class-protocol/attributes/classes/class" mode="crc" />
                    <xsl:apply-templates select="instance-protocol/attributes/classes/interface" mode="crc" />
                    <xsl:apply-templates select="instance-protocol/attributes/classes/class" mode="crc" />
                </tbody>
            </table>
        </xsl:if>
    </xsl:template>

    <xsl:template match="feature" mode="cd">
        <xsl:apply-templates select="feature" mode="cd" />
        <xsl:apply-templates select="class-protocol/attributes/classes/interface" mode="cd" />
        <xsl:apply-templates select="class-protocol/attributes/classes/class" mode="cd" />
        <xsl:apply-templates select="instance-protocol/attributes/classes/interface" mode="cd" />
        <xsl:apply-templates select="instance-protocol/attributes/classes/class" mode="cd" />
    </xsl:template>

    <xsl:template match="feature" mode="crc">
        <xsl:apply-templates select="feature" mode="crc" />
        <xsl:apply-templates select="class-protocol/attributes/classes/interface" mode="crc" />
        <xsl:apply-templates select="class-protocol/attributes/classes/class" mode="crc" />
        <xsl:apply-templates select="instance-protocol/attributes/classes/interface" mode="crc" />
        <xsl:apply-templates select="instance-protocol/attributes/classes/class" mode="crc" />
    </xsl:template>

</xsl:stylesheet>