<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2014 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" />

    <!-- operations overview -->

    <xsl:template match="class" mode="overview_operations">
        <!-- MSD -->
        <xsl:variable name="canPerformMSD1" select="class-protocol/operations or instance-protocol/operations" />
        <xsl:variable name="canPerformMSD2" select=".//feature/class-protocol/operations" />
        <xsl:variable name="canPerformMSD3" select=".//feature/instance-protocol/operations" />
        <xsl:variable name="canPerformMSD" select="$canPerformMSD1 or $canPerformMSD2 or $canPerformMSD3" />
        <xsl:if test="$canPerformMSD">
            <table class="overview">
                <caption>Operation - Signature / Description</caption>
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Signature / Description</th>
                    </tr>
                </thead>
                <tbody>
                    <xsl:apply-templates select="feature" mode="msd" />
                    <xsl:apply-templates select="class-protocol/operations/." mode="msd" />
                    <xsl:apply-templates select="instance-protocol/operations/." mode="msd" />
                </tbody>
            </table>
        </xsl:if>
    </xsl:template>

    <!-- Operation - Signature / Description -->

    <xsl:template match="feature" mode="msd">
        <xsl:apply-templates select="feature" mode="msd" />
        <xsl:apply-templates select="class-protocol/operations/." mode="msd" />
        <xsl:apply-templates select="instance-protocol/operations/." mode="msd" />
    </xsl:template>

    <!-- constructor -->

    <xsl:template match="constructor" mode="msd">
        <tr>
            <td>
                <xsl:choose>
                    <xsl:when test="@id">
                        <a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:apply-templates select="." mode="msd_name" /></a>
                    </xsl:when>
                    <xsl:otherwise>
                        <a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:apply-templates select="." mode="msd_name" /></a>
                    </xsl:otherwise>
                </xsl:choose>
            </td>
            <td>
                <dl class="msd">
                    <dt>
                        <xsl:apply-templates select="." mode="short_signature" />
                    </dt>
                    <dd>
                        <xsl:apply-templates select="description" mode="overview" />
                    </dd>
                </dl>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="constructor" mode="msd_name">
        <xsl:choose>
            <xsl:when test="@visibility = 'public'"> public </xsl:when>
            <xsl:when test="@visibility = 'protected'"> protected </xsl:when>
            <xsl:when test="@visibility = 'private'"> private </xsl:when>
            <xsl:when test="@visibility = 'package'"> package </xsl:when>
            <xsl:otherwise> public </xsl:otherwise>
        </xsl:choose>
        constructor
        <xsl:value-of select="@name" />
    </xsl:template>

    <xsl:template match="constructor" mode="short_signature">
        <xsl:choose>
            <xsl:when test="@name"><xsl:value-of select="@name" /></xsl:when>
            <xsl:otherwise>constructor</xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="parameters" mode="header" />
    </xsl:template>

    <xsl:template match="constructor/description" mode="overview">
        <xsl:apply-templates />
    </xsl:template>

    <!-- destructor -->

    <xsl:template match="destructor" mode="msd">
        <tr>
            <td>
                <xsl:choose>
                    <xsl:when test="@id">
                        <a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:apply-templates select="." mode="msd_name" /></a>
                    </xsl:when>
                    <xsl:otherwise>
                        <a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:apply-templates select="." mode="msd_name" /></a>
                    </xsl:otherwise>
                </xsl:choose>
            </td>
            <td>
                <dl class="msd">
                    <dt>
                        <xsl:apply-templates select="." mode="short_signature" />
                    </dt>
                    <dd>
                        <xsl:apply-templates select="description" mode="overview" />
                    </dd>
                </dl>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="destructor" mode="msd_name">
        <xsl:choose>
            <xsl:when test="@visibility = 'public'"> public </xsl:when>
            <xsl:when test="@visibility = 'protected'"> protected </xsl:when>
            <xsl:when test="@visibility = 'private'"> private </xsl:when>
            <xsl:when test="@visibility = 'package'"> package </xsl:when>
            <xsl:otherwise> public </xsl:otherwise>
        </xsl:choose>
        destructor
        <xsl:value-of select="@name" />
    </xsl:template>

    <xsl:template match="destructor" mode="short_signature">
        <xsl:choose>
            <xsl:when test="@name"><xsl:value-of select="@name" /></xsl:when>
            <xsl:otherwise>destructor</xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="parameters" mode="header" />
    </xsl:template>

    <xsl:template match="destructor/description" mode="overview">
        <xsl:apply-templates />
    </xsl:template>

    <!-- method -->

    <xsl:template match="method" mode="msd">
        <tr>
            <td>
                <xsl:choose>
                    <xsl:when test="@id">
                        <a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:apply-templates select="." mode="msd_name" /></a>
                    </xsl:when>
                    <xsl:otherwise>
                        <a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:apply-templates select="." mode="msd_name" /></a>
                    </xsl:otherwise>
                </xsl:choose>
            </td>
            <td>
                <dl class="msd">
                    <dt>
                        <xsl:apply-templates select="." mode="short_signature" />
                    </dt>
                    <dd>
                        <xsl:apply-templates select="description" mode="overview" />
                    </dd>
                </dl>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="method" mode="msd_name">
        <xsl:choose>
            <xsl:when test="@visibility = 'public'"> public </xsl:when>
            <xsl:when test="@visibility = 'protected'"> protected </xsl:when>
            <xsl:when test="@visibility = 'private'"> private </xsl:when>
            <xsl:when test="@visibility = 'package'"> package </xsl:when>
            <xsl:otherwise> public </xsl:otherwise>
        </xsl:choose>
        method
        <xsl:value-of select="@name" />
    </xsl:template>

    <xsl:template match="method" mode="short_signature">
        <xsl:value-of select="@name" />
        <xsl:apply-templates select="parameters" mode="header" />
        <xsl:apply-templates select="returns" mode="header" />
    </xsl:template>

    <xsl:template match="method/description" mode="overview">
        <xsl:apply-templates />
    </xsl:template>

    <!-- operator -->

    <xsl:template match="operator" mode="msd">
        <tr>
            <td>
                <xsl:choose>
                    <xsl:when test="@id">
                        <a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:apply-templates select="." mode="msd_name" /></a>
                    </xsl:when>
                    <xsl:otherwise>
                        <a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:apply-templates select="." mode="msd_name" /></a>
                    </xsl:otherwise>
                </xsl:choose>
            </td>
            <td>
                <dl class="msd">
                    <dt>
                        <xsl:apply-templates select="." mode="short_signature" />
                    </dt>
                    <dd>
                        <xsl:apply-templates select="description" mode="overview" />
                    </dd>
                </dl>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="operator" mode="msd_name">
        <xsl:choose>
            <xsl:when test="@visibility = 'public'"> public </xsl:when>
            <xsl:when test="@visibility = 'protected'"> protected </xsl:when>
            <xsl:when test="@visibility = 'private'"> private </xsl:when>
            <xsl:when test="@visibility = 'package'"> package </xsl:when>
            <xsl:otherwise> public </xsl:otherwise>
        </xsl:choose>
        operator
        <xsl:value-of select="@signature" />
    </xsl:template>

    <xsl:template match="operator" mode="short_signature">
        operator
        <xsl:value-of select="@signature" />
        <xsl:apply-templates select="parameters" mode="header" />
        <xsl:apply-templates select="returns" mode="header" />
    </xsl:template>

    <xsl:template match="operator/description" mode="overview">
        <xsl:apply-templates />
    </xsl:template>

    <!-- thread -->

    <xsl:template match="thread" mode="msd">
        <tr>
            <td>
                <xsl:choose>
                    <xsl:when test="@id">
                        <a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:apply-templates select="." mode="msd_name" /></a>
                    </xsl:when>
                    <xsl:otherwise>
                        <a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:apply-templates select="." mode="msd_name" /></a>
                    </xsl:otherwise>
                </xsl:choose>
            </td>
            <td>
                <dl class="msd">
                    <dt>
                        <xsl:apply-templates select="." mode="short_signature" />
                    </dt>
                    <dd>
                        <xsl:apply-templates select="description" mode="overview" />
                    </dd>
                </dl>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="thread" mode="msd_name">
        <xsl:choose>
            <xsl:when test="@visibility = 'public'"> public </xsl:when>
            <xsl:when test="@visibility = 'protected'"> protected </xsl:when>
            <xsl:when test="@visibility = 'private'"> private </xsl:when>
            <xsl:when test="@visibility = 'package'"> package </xsl:when>
            <xsl:otherwise> public </xsl:otherwise>
        </xsl:choose>
        thread
        <xsl:value-of select="@name" />
    </xsl:template>

    <xsl:template match="thread" mode="short_signature">
        thread
        <xsl:value-of select="@name" />
    </xsl:template>

    <xsl:template match="thread/description" mode="overview">
        <xsl:apply-templates />
    </xsl:template>

</xsl:stylesheet>