<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" />

    <!-- test procedures overview -->

    <xsl:template match="solution | implementation | package | model | realization | function | test-procedure | constructor | destructor | method | operator" mode="overview_test_procedures">
        <xsl:if test="test-procedures">
            <table class="overview">
                <caption>Test procedure - Signature / Description</caption>
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Signature / Description</th>
                    </tr>
                </thead>
                <tbody>
                    <xsl:apply-templates select="test-procedures/test-procedure" mode="tpsd" />
                </tbody>
            </table>
        </xsl:if>
    </xsl:template>

    <!-- test procedure - signature / description -->

    <xsl:template match="test-procedure" mode="tpsd">
        <tr>
            <td>
                <xsl:choose>
                    <xsl:when test="@id">
                        <a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a>
                    </xsl:when>
                    <xsl:otherwise>
                        <a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a>
                    </xsl:otherwise>
                </xsl:choose>
            </td>
            <td>
                <dl class="tpsd">
                    <dt>
                        <xsl:apply-templates select="." mode="short_signature" />
                    </dt>
                    <dd>
                        <xsl:apply-templates select="description" mode="overview" />
                    </dd>
                </dl>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="test-procedure" mode="short_signature">
        <xsl:value-of select="@name" />
        <xsl:apply-templates select="parameters" mode="header" />
    </xsl:template>

    <xsl:template match="test-procedure/description" mode="overview">
        <xsl:apply-templates />
    </xsl:template>

</xsl:stylesheet>