<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
	<!-- algorithm -->
    
	<xsl:template match="algorithm">
		<h4 onclick="toggleAlgorithm('{generate-id(.)}')">Algorithm</h4>
		<ol id="{generate-id(.)}" state="collapsed" class="algorithm"><xsl:apply-templates /></ol>
	</xsl:template>
	
	<xsl:template match="algorithm" mode="content">
		<xsl:apply-templates />
	</xsl:template>

	<!-- step -->
	
	<xsl:template match="step">
		<li>
			<span id="{generate-id(.)}-action"><a href="javascript:expandStep('{generate-id(.)}')"><xsl:apply-templates select="action" mode="content" /></a></span> 
			<ol id="{generate-id(.)}-detailing" style="display:none">
				<xsl:apply-templates select="detailing" />
			</ol>
		</li>
	</xsl:template>
	
	<xsl:template match="detailing">
		<xsl:apply-templates />
	</xsl:template>
	
	<!-- perform -->
	
	<xsl:template match="perform">
		<li>
			<span id="{generate-id(.)}-action"><a href="javascript:expandStep('{generate-id(.)}')"> perform 
				<xsl:choose>
					<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@action" /></a></xsl:when>
					<xsl:otherwise><xsl:value-of select="@action" /></xsl:otherwise>
				</xsl:choose>
			</a></span> 
			<ol id="{generate-id(.)}-detailing" style="display:none">
				<xsl:apply-templates />
			</ol>
		</li>
	</xsl:template>	

	<!-- action -->
	
	<xsl:template match="action">
		<li><xsl:apply-templates /></li>
	</xsl:template>
	
	<xsl:template match="action" mode="content">
		<xsl:apply-templates />
	</xsl:template>	
	
	<!-- do -->
	
	<xsl:template match="do">
		<ol><xsl:apply-templates /></ol>
	</xsl:template>
	
	<!-- do-in-parallel -->
	
	<xsl:template match="do-in-parallel">
		<li> do in parrallel
			<ol>
				<xsl:apply-templates select="do" />
			</ol>
		</li>
		<li> end do in parallel </li>
	</xsl:template>
	
	<xsl:template match="do-in-parallel/do">
		<li> do 
			<ol><xsl:apply-templates /></ol>
		</li>
		<li> end do </li>
	</xsl:template>
	
	<!-- go -->
	
	<xsl:template match="go">
		<li> go thread 
			<xsl:choose>
				<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@thread" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@thread" /></xsl:otherwise>
			</xsl:choose>
		</li>
	</xsl:template>
	
	<!-- call -->
	
	<xsl:template match="call">
		<a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="." /></a>
	</xsl:template>
	
	<!-- assert -->
	
	<xsl:template match="assert">
		<li>assert that 
			<xsl:choose>
				<xsl:when test="@reference"><a href="#{@reference}"><xsl:value-of select="@actual" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@actual" /></xsl:otherwise>
			</xsl:choose>
			equals to
			<xsl:value-of select="@expected" />
			<xsl:if test="@delta">
				despite 
				<xsl:value-of select="@delta" />
			</xsl:if>
		</li>
	</xsl:template>
	
	<!-- assert-true -->
	
	<xsl:template match="assert-true">
		<li>assert that 
			<xsl:choose>
				<xsl:when test="@reference"><a href="#{@reference}"><xsl:value-of select="@assertion" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@assertion" /></xsl:otherwise>
			</xsl:choose>
		</li>
	</xsl:template>
	
	<!-- break -->
	
	<xsl:template match="break">
		<li> break
			<xsl:if test="@label"> cycle <a href="#{@label}"><xsl:value-of select="@label" /></a></xsl:if>
			<xsl:if test="condition">
				if 
				<xsl:apply-templates select="condition" />
			</xsl:if>			
		</li>
	</xsl:template>
	
	<!-- continue -->
	
	<xsl:template match="continue">
		<li> continue
			<xsl:if test="@label"> cycle <a href="#{@label}"><xsl:value-of select="@label" /></a></xsl:if>
			<xsl:if test="condition">
				if 
				<xsl:apply-templates select="condition" />
			</xsl:if>			
		</li>
	</xsl:template>
	
	<!-- return -->
	
	<xsl:template match="return">
		<li> 
			return
            <xsl:choose>
                <xsl:when test="@conditionally = 'yes'">
                    <xsl:choose>
                        <xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@value" /></a></xsl:when>
                        <xsl:otherwise><xsl:value-of select="@value" /></xsl:otherwise>
                    </xsl:choose>
                    <xsl:if test="condition">
                        if
                        <xsl:apply-templates select="condition" />
                    </xsl:if>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:choose>
                        <xsl:when test="condition">
                            <xsl:apply-templates select="condition" />
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:choose>
                                <xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@value" /></a></xsl:when>
                                <xsl:otherwise><xsl:value-of select="@value" /></xsl:otherwise>
                            </xsl:choose>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:otherwise>
            </xsl:choose>
		</li>
	</xsl:template>
	
	<!-- throw -->
	
	<xsl:template match="throw">
		<li> throw
			<xsl:if test="@exception">
				<xsl:choose>
					<xsl:when test="@reference-to-exception"><a href="#{@reference-to-exception}" onclick="expandAncestors('{@reference-to-exception}')"><xsl:value-of select="@exception" /></a></xsl:when>
					<xsl:otherwise><xsl:value-of select="@exception" /></xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="@exception and @type"> as </xsl:when>
				<xsl:when test="@type"> new </xsl:when>
			</xsl:choose>
			<xsl:if test="@type">
				<xsl:choose>
					<xsl:when test="@reference-to-type"><a href="#{@reference-to-type}" onclick="expandAncestors('{@reference-to-type}')"><xsl:value-of select="@type" /></a></xsl:when>
					<xsl:otherwise><xsl:value-of select="@type" /></xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="not(@exception) and not(@type)"><em class="comment"> { Warning : the exception is not defined } </em></xsl:if>
		</li>
	</xsl:template>	
	
	<!-- with -->
	
	<xsl:template match="with">
		<li> with 
			<xsl:choose>
				<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@object" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@object" /></xsl:otherwise>
			</xsl:choose>
			do
			<ol><xsl:apply-templates /></ol>
		</li>
		<li> end with </li>
	</xsl:template>
	
	<!-- increase -->
	
	<xsl:template match="increase">
		<li>
			<xsl:choose>
				<xsl:when test="@by">
					increase 
					<xsl:choose>
						<xsl:when test="@reference-to-variable"><a href="#{@reference-to-variable}" onclick="expandAncestors('{@reference-to-variable}')"><xsl:value-of select="@variable"/></a></xsl:when>
						<xsl:otherwise><xsl:value-of select="@variable"/></xsl:otherwise>
					</xsl:choose>
					by
					<xsl:choose>
						<xsl:when test="@reference-to-by"><a href="#{@reference-to-by}" onclick="expandAncestors('{@reference-to-by}')"><xsl:value-of select="@by" /></a></xsl:when>
						<xsl:otherwise><xsl:value-of select="@by" /></xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					increment 
					<xsl:choose>
						<xsl:when test="@reference-to-variable"><a href="#{@reference-to-variable}" onclick="expandAncestors('{@reference-to-variable}')"><xsl:value-of select="@variable"/></a></xsl:when>
						<xsl:otherwise><xsl:value-of select="@variable"/></xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</li>		
	</xsl:template>
	
	<!-- decrease -->
	
	<xsl:template match="decrease">
		<li>
			<xsl:choose>
				<xsl:when test="@by">
					decrease 
					<xsl:choose>
						<xsl:when test="@reference-to-variable"><a href="#{@reference-to-variable}" onclick="expandAncestors('{@reference-to-variable}')"><xsl:value-of select="@variable"/></a></xsl:when>
						<xsl:otherwise><xsl:value-of select="@variable"/></xsl:otherwise>
					</xsl:choose>
					by
					<xsl:choose>
						<xsl:when test="@reference-to-by"><a href="#{@reference-to-by}" onclick="expandAncestors('{@reference-to-by}')"><xsl:value-of select="@by" /></a></xsl:when>
						<xsl:otherwise><xsl:value-of select="@by" /></xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>	
					decrement 
					<xsl:choose>
						<xsl:when test="@reference-to-variable"><a href="#{@reference-to-variable}" onclick="expandAncestors('{@reference-to-variable}')"><xsl:value-of select="@variable"/></a></xsl:when>
						<xsl:otherwise><xsl:value-of select="@variable"/></xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</li>
	</xsl:template>
	
	<!-- wait -->
	
	<xsl:template match="wait">
		<li>
			wait for signal
			<xsl:choose>
				<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@signal" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@signal" /></xsl:otherwise>
			</xsl:choose>
		</li>
	</xsl:template>
	
	<!-- notify -->
	
	<xsl:template match="notify">
		<li>
			notify by signal 
			<xsl:choose>
				<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@signal" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@signal" /></xsl:otherwise>
			</xsl:choose>
		</li>
	</xsl:template>
	
	<!-- input -->
	
	<xsl:template match="input">
		<li>
			input 
			<xsl:choose>
				<xsl:when test="@reference-to-variable"><a href="#{@reference-to-variable}" onclick="expandAncestors('{@reference-to-variable}')"><xsl:value-of select="@variable" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@variable" /></xsl:otherwise>
			</xsl:choose>
			from channel 
			<xsl:choose>
				<xsl:when test="@reference-to-channel"><a href="#{@reference-to-channel}" onclick="expandAncestors('{@reference-to-channel}')"><xsl:value-of select="@channel" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@channel" /></xsl:otherwise>
			</xsl:choose>
		</li>
	</xsl:template>
	
	<!-- output -->
	
	<xsl:template match="output">
		<li>
			output 
			<xsl:choose>
				<xsl:when test="@reference-to-variable"><a href="#{@reference-to-variable}" onclick="expandAncestors('{@reference-to-variable}')"><xsl:value-of select="@variable" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@variable" /></xsl:otherwise>
			</xsl:choose>
			in channel 
			<xsl:choose>
				<xsl:when test="@reference-to-channel"><a href="#{@reference-to-channel}" onclick="expandAncestors('{@reference-to-channel}')"><xsl:value-of select="@channel" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@channel" /></xsl:otherwise>
			</xsl:choose>
		</li>
	</xsl:template>

    <!-- initiate -->

    <xsl:template match="initiate">
        <li>
            initiate
            <xsl:choose>
                <xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@thread" /></a></xsl:when>
                <xsl:otherwise><xsl:value-of select="@thread" /></xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>
	
	<!-- perform-operations -->
	
	<xsl:template match="perform-operations">
		<li>perform operations</li>
	</xsl:template>
	
	<!-- comment -->
	
	<xsl:template match="comment">
		<em class="comment"> { <xsl:value-of select="." /> } </em>
	</xsl:template> 
	
</xsl:stylesheet>
