<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8"/>
	
	<!-- researches -->

	<xsl:template match="solution | analysis | model | implementation | catalog" mode="table_of_contents_researches">
		<xsl:if test="researches">
			<li><a href="#{generate-id(researches)}">Researches</a></li>
		</xsl:if>
	</xsl:template>

	<xsl:template match="researches">
		<h3 id="{generate-id(.)}" onclick="toggleResearches()">Researches</h3>
		<ul id="researchesList" class="researches" state="collapsed">
			<xsl:apply-templates />
		</ul>
	</xsl:template>
	
	<xsl:template match="research-package">
		<li><a href="javascript:toggleTag('{generate-id(.)}')" title="{@name} package"><xsl:value-of select="@name" /></a>
			<ul id="{generate-id(.)}" class="research-package" style="display:none">
				<xsl:apply-templates />
			</ul>
		</li>
	</xsl:template>
	
	<!-- document -->
	
	<xsl:template match="document">
		<li>
			<xsl:choose>
				<xsl:when test="$out = 'file'"><a href="{@page}" title="{@page}"><xsl:value-of select="@name" /></a></xsl:when>
				<xsl:otherwise><a href="{@file}" title="{@file}"><xsl:value-of select="@name" /></a></xsl:otherwise>
			</xsl:choose>
		</li>
	</xsl:template>	
	
</xsl:stylesheet>
