<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
	<!-- test plan -->

	<xsl:template match="solution | analysis | model | implementation | catalog" mode="table_of_contents_test_plan">
		<xsl:if test="test-plan">
			<li><a href="#{generate-id(test-plan)}">Test plan</a></li>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="test-plan">
		<h3 id="{generate-id(.)}" onclick="toggleTests()">Test plan</h3>
		<ul id="testsList" class="test-plan" state="collapsed">
			<xsl:apply-templates select="test-package" />
		</ul>
	</xsl:template>
	
	<xsl:template match="test-package">
		<xsl:param name="suffix" required="no" as="xs:string" />
		<xsl:choose>
			<xsl:when test="$suffix = ''">
				<li><a href="javascript:toggleTag('{generate-id(.)}')"><xsl:value-of select="@name" /></a>
					<ol id="{generate-id(.)}" class="test-package" style="display:none">
						<xsl:apply-templates />
					</ol>
				</li>
			</xsl:when>
			<xsl:otherwise>
				<li><a href="javascript:toggleTag('{generate-id(.)}{$suffix}')"><xsl:value-of select="@name" /></a>
					<ol id="{generate-id(.)}{$suffix}" class="test-package" style="display:none">
						<xsl:apply-templates>
							<xsl:with-param name="suffix" select="$suffix" />
						</xsl:apply-templates>
					</ol>
				</li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="test">
		<xsl:variable name="reference" select="@reference" />
		<xsl:choose>
			<xsl:when test="$reference = //test-procedure/@id">
				<xsl:for-each select="//test-procedure[@id = $reference]">
					<li><a href="#{@id}" onclick="expandAncestors('{@id}')">Test procedure <xsl:value-of select="@name" /></a></li>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="$reference = //test-scenario/@id">
				<xsl:for-each select="//test-scenario[@id = $reference]">
					<li><a href="#{@id}" onclick="expandAncestors('{@id}')">Test scenario <xsl:value-of select="@name" /></a></li>
				</xsl:for-each>
			</xsl:when>			
			<xsl:when test="$reference = //test-package/@id">
				<xsl:choose>
					<xsl:when test="ancestor::node()[@id = $reference]">
						<li><em class="comment"> { Warning : the recursion in test } </em></li>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="//test-package[@id = $reference]">
						 	<xsl:with-param name="suffix" select="generate-id(.)" />
						</xsl:apply-templates>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<li><em class="comment"> { Warning : the test is not found } </em></li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>