<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- attributes -->

    <xsl:template match="worker | worker-feature | entity | entity-feature" mode="attributes">
        <xsl:if test="attribute">
            <h3>Attributes</h3>
            <div class="indent">
                <table class="protocol">
                    <thead>
                        <tr>
                            <th>name</th>
                            <th>description</th>
                        </tr>
                    </thead>
                    <tbody>
                        <xsl:for-each select="attribute">
                            <xsl:choose>
                                <xsl:when test="@id">
                                    <tr id="{@id}">
                                        <td><xsl:apply-templates select="." mode="name" /></td>
                                        <td><xsl:apply-templates select="." mode="description" /></td>
                                    </tr>
                                </xsl:when>
                                <xsl:otherwise>
                                    <tr>
                                        <td><xsl:apply-templates select="." mode="name" /></td>
                                        <td><xsl:apply-templates select="." mode="description" /></td>
                                    </tr>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:for-each>
                    </tbody>
                </table>
            </div>
        </xsl:if>
    </xsl:template>

    <xsl:template match="worker/attribute | worker-feature/attribute | entity/attribute | entity-feature/attribute" mode="name">
        <xsl:value-of select="@name" />
        <xsl:if test="@class">
            as
            <xsl:choose>
                <xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@class" /></a></xsl:when>
                <xsl:otherwise><xsl:value-of select="@class" /></xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>

    <xsl:template match="worker/attribute | worker-feature/attribute | entity/attribute | entity-feature/attribute" mode="description">
        <xsl:apply-templates />
    </xsl:template>

</xsl:stylesheet>