<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- business actors -->

    <xsl:template match="domain | package" mode="table_of_contents_actors">
        <xsl:if test="actor">
            <li>
                <xsl:choose>
                    <xsl:when test="count(actor) = 1">Actor</xsl:when>
                    <xsl:otherwise>Actors</xsl:otherwise>
                </xsl:choose>
                <ul>
                    <xsl:for-each select="actor">
                        <li>
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="domain/actor">
        <xsl:choose>
            <xsl:when test="@id"><h2 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Actor : <xsl:apply-templates select="." mode="name" /></h2></xsl:when>
            <xsl:otherwise><h2 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Actor : <xsl:apply-templates select="." mode="name" /></h2></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" class="indent">
            <xsl:apply-templates select="." mode="content" />
        </div>
    </xsl:template>

    <xsl:template match="package/actor">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Actor : <xsl:apply-templates select="." mode="name" /></h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Actor : <xsl:apply-templates select="." mode="name" /></h3></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" class="indent">
            <xsl:apply-templates select="." mode="content" />
        </div>
    </xsl:template>

    <xsl:template match="actor" mode="name">
        <xsl:value-of select="@name" />
        <xsl:if test="@extends">
            extends
            <xsl:choose>
                <xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@extends" /></a></xsl:when>
                <xsl:otherwise><xsl:value-of select="@extends" /></xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>

    <xsl:template match="actor" mode="content">
        <xsl:choose>
            <xsl:when test="description and not(specification) and not(participant) and not(characteristics) and not(responsibility) and not(communicate-association)">
                <xsl:apply-templates select="description" mode="content" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="description" />
                <xsl:apply-templates select="specification" />
                <xsl:apply-templates select="goal" />
                <xsl:apply-templates select="." mode="participation" />
                <xsl:apply-templates select="characteristics" />
                <xsl:apply-templates select="." mode="responsibilities" />
                <xsl:apply-templates select="." mode="communicate-associations" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="actor/goal">
        <h3>Goal</h3>
        <div class="indent">
            <xsl:apply-templates />
        </div>
    </xsl:template>

</xsl:stylesheet>