<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- classes -->

    <xsl:template match="actor/description | worker/description | worker-feature/description | entity/description | entity-feature/description">
        <h3>Description</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="actor/description | worker/description | entity/description" mode="content">
        <xsl:apply-templates />
    </xsl:template>

    <xsl:template match="actor | worker" mode="participation">
        <xsl:if test="participant">
            <h3 onclick="toggleTag('{generate-id(.)}-participation')">Participation</h3>
            <div id="{generate-id()}-participation" class="indent">
                <table class="participation">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>participation</th>
                        </tr>
                    </thead>
                    <tbody>
                        <xsl:apply-templates select="participant" />
                    </tbody>
                </table>
            </div>
        </xsl:if>
    </xsl:template>

    <xsl:template match="actor/characteristics | worker/characteristics">
        <h3>Characteristics</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="actor | worker | worker-feature | entity | entity-feature" mode="responsibilities">
        <xsl:if test="responsibility">
            <h3>Responsibilities</h3>
            <ul class="attributes">
                <xsl:for-each select="responsibility">
                    <xsl:choose>
                        <xsl:when test="@id"><li id="{@id}"><xsl:apply-templates /></li></xsl:when>
                        <xsl:otherwise><li><xsl:apply-templates /></li></xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
            </ul>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>