<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2014 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" />

    <!-- contract -->

    <xsl:template match="contract">
        <h3 onclick="toggleTag('{generate-id(.)}')">Contract</h3>
        <div id="{generate-id(.)}" class="indent">
            <xsl:choose>
                <xsl:when test="invariant or effect">
                    <xsl:apply-templates select="invariant" />
                    <xsl:apply-templates select="effect" />
                </xsl:when>
                <xsl:otherwise>
                    <em class="comment"> { Warning : the contract is not defined } </em>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>

    <xsl:template match="contract/invariant">
        <h3 onclick="toggleTag('{generate-id(.)}')">Invariant
            <xsl:if test="@name"> named as <xsl:value-of select="@name" /> </xsl:if>
        </h3>
        <div id="{generate-id(.)}" class="indent">
            <xsl:apply-templates select="." mode="content" />
            <xsl:apply-templates select="screen" mode="content" />
            <xsl:apply-templates select="diagram" mode="content" />
        </div>
    </xsl:template>

    <xsl:template match="contract/effect">
        <xsl:choose>
            <xsl:when test="precondition and not(postcondition)">
                <h3 onclick="toggleTag('{generate-id(.)}')">Precondition
                    <xsl:if test="precondition/@name"> named as <xsl:value-of select="precondition/@name" /> </xsl:if>
                </h3>
                <div id="{generate-id(.)}" class="indent">
                    <xsl:apply-templates select="precondition" mode="content" />
                    <xsl:apply-templates select="precondition/screen" mode="content" />
                    <xsl:apply-templates select="precondition/diagram" mode="content" />
                </div>
            </xsl:when>
            <xsl:when test="not(precondition) and postcondition">
                <h3 onclick="toggleTag('{generate-id(.)}')">Postcondition
                    <xsl:if test="postcondition/@name"> named as <xsl:value-of select="postcondition/@name" /> </xsl:if>
                </h3>
                <div id="{generate-id(.)}" class="indent">
                    <xsl:apply-templates select="postcondition" mode="content" />
                    <xsl:apply-templates select="postcondition/screen" mode="content" />
                    <xsl:apply-templates select="postcondition/diagram" mode="content" />
                </div>
            </xsl:when>
            <xsl:when test="precondition and postcondition">
                <h3 onclick="toggleTag('{generate-id(.)}')">Postcondition
                    <xsl:if test="postcondition/@name"> named as <xsl:value-of select="postcondition/@name" /> </xsl:if>
                </h3>
                <div id="{generate-id(.)}" class="indent">
                    <h3 onclick="toggleTag('{generate-id(.)}-precondition')">for precondition
                        <xsl:if test="precondition/@name"> named as <xsl:value-of select="precondition/@name" /> </xsl:if>
                    </h3>
                    <div id="{generate-id(.)}-precondition" class="indent">
                        <xsl:apply-templates select="precondition" mode="content" />
                        <xsl:apply-templates select="precondition/screen" mode="content" />
                        <xsl:apply-templates select="precondition/diagram" mode="content" />
                    </div>
                    <h3 onclick="toggleTag('{generate-id(.)}-postcondition')">is</h3>
                    <div id="{generate-id(.)}-postcondition" class="indent">
                        <xsl:apply-templates select="postcondition" mode="content" />
                        <xsl:apply-templates select="postcondition/screen" mode="content" />
                        <xsl:apply-templates select="postcondition/diagram" mode="content" />
                    </div>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <em class="comment"> { Warning : the effect is not defined } </em>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="invariant/screen | precondition/screen | postcondition/screen" mode="content">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Screen : <xsl:value-of  select="@name" /></h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Screen : <xsl:value-of  select="@name" /></h3></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}">
            <img alt="{@name}" src="{@image}" style="float:left; padding-right:10px" />
            <div style="display:inline">
                <xsl:apply-templates />
            </div>
            <br style="clear:left" />
        </div>
    </xsl:template>

    <xsl:template match="invariant/diagram | precondition/diagram | postcondition/diagram" mode="content">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Diagram : <xsl:value-of select="@name" /></h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Diagram : <xsl:value-of select="@name" /></h3></xsl:otherwise>
        </xsl:choose>
        <img id="{generate-id(.)}" alt="{@name}" src="{@image}" />
    </xsl:template>

</xsl:stylesheet>