<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2014 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- entity - description -->

    <xsl:template match="domain | package | use-case | segment" mode="overview_entities">
        <xsl:if test="entity">
            <table class="overview">
                <caption>Entity - Description</caption>
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Description</th>
                    </tr>
                </thead>
                <tbody>
                    <xsl:apply-templates select="entity" mode="ed" />
                </tbody>
            </table>
        </xsl:if>
    </xsl:template>

    <xsl:template match="entity" mode="ed">
        <tr>
            <td>
                <xsl:choose>
                    <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                    <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                </xsl:choose>
            </td>
            <td>
                <xsl:apply-templates select="description" mode="onlyDescription" />
                <xsl:apply-templates select="entity-feature" mode="ed" />
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="entity-feature" mode="ed">
        <xsl:variable name="canPerform" select=".//entity-feature/description or description" as="xs:boolean" />
        <xsl:if test="$canPerform">
            <h3>Feature :
                <xsl:choose>
                    <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                    <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                </xsl:choose>
            </h3>
            <div class="indent">
                <xsl:apply-templates select="description" mode="onlyDescription" />
                <xsl:apply-templates select="entity-feature" mode="ed" />
            </div>
        </xsl:if>
    </xsl:template>

    <xsl:template match="entity/description | entity-feature/description" mode="onlyDescription">
        <xsl:apply-templates />
    </xsl:template>

</xsl:stylesheet>