<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- overview -->

    <!-- domain and package -->

    <xsl:template match="domain | package" mode="table_of_contents_overview">
        <xsl:if test="package or actor or worker or entity or use-case">
            <li><a href="#{generate-id(.)}-overview-header"  onclick="expandAncestors('{generate-id(.)}-overview-header')">Overview</a></li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="domain" mode="overview">
        <xsl:if test="package or actor or worker or entity or use-case">
            <h2 id="{generate-id(.)}-overview-header" onclick="toggleTag('{generate-id(.)}-overview')">Overview</h2>
            <xsl:apply-templates select="." mode="overview_content" />
        </xsl:if>
    </xsl:template>

    <xsl:template match="package" mode="overview">
        <xsl:if test="package or actor or worker or entity or use-case">
            <h3 id="{generate-id(.)}-overview-header" onclick="toggleTag('{generate-id(.)}-overview')">Overview</h3>
            <xsl:apply-templates select="." mode="overview_content" />
        </xsl:if>
    </xsl:template>

    <xsl:template match="domain | package" mode="overview_content">
        <div id="{generate-id(.)}-overview" class="indent" style="display:none">
            <xsl:apply-templates select="." mode="overview_packages" />
            <xsl:apply-templates select="." mode="overview_actors" />
            <xsl:apply-templates select="." mode="overview_workers" />
            <xsl:apply-templates select="." mode="overview_entities" />
            <xsl:apply-templates select="." mode="overview_use_cases" />
        </div>
    </xsl:template>

    <!-- use case and segment -->

    <xsl:template match="use-case | segment" mode="table_of_contents_overview">
        <xsl:if test="package or worker or entity or use-case">
            <li><a href="#{generate-id(.)}-overview-header"  onclick="expandAncestors('{generate-id(.)}-overview-header')">Overview</a></li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="use-case | segment" mode="overview">
        <xsl:if test="package or worker or entity or use-case">
            <h3 id="{generate-id(.)}-overview-header" onclick="toggleTag('{generate-id(.)}-overview')">Overview</h3>
            <div id="{generate-id(.)}-overview" class="indent" style="display:none">
                <xsl:apply-templates select="." mode="overview_packages" />
                <xsl:apply-templates select="." mode="overview_workers" />
                <xsl:apply-templates select="." mode="overview_entities" />
                <xsl:apply-templates select="." mode="overview_use_cases" />
            </div>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>