<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2014 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- use case - description -->

    <xsl:template match="domain | package | use-case | segment" mode="overview_use_cases">
        <xsl:if test="use-case">
            <table class="overview">
                <caption>Use case - Description</caption>
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Description</th>
                    </tr>
                </thead>
                <tbody>
                    <xsl:apply-templates select="use-case" mode="usd" />
                </tbody>
            </table>
        </xsl:if>
    </xsl:template>

    <xsl:template match="use-case" mode="usd">
        <tr>
            <td>
                <xsl:choose>
                    <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                    <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                </xsl:choose>
            </td>
            <td>
                <xsl:choose>
                    <xsl:when test="description"><xsl:apply-templates select="description" mode="overview" /></xsl:when>
                    <xsl:when test="scenario/description"><xsl:apply-templates select="scenario/description" mode="overview" /></xsl:when>
                </xsl:choose>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="use-case/description" mode="overview">
        <xsl:apply-templates />
    </xsl:template>

    <xsl:template match="scenario/description" mode="overview">
        <xsl:apply-templates />
    </xsl:template>

</xsl:stylesheet>