<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- associations -->

    <xsl:template match="worker | worker-feature | entity | entity-feature" mode="associations">
        <xsl:if test="association">
            <h3>Associations</h3>
            <div class="indent">
                <table class="protocol">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>association</th>
                        </tr>
                    </thead>
                    <tbody>
                        <xsl:apply-templates select="association" />
                    </tbody>
                </table>
            </div>
        </xsl:if>
    </xsl:template>

    <xsl:template match="worker/association | worker-feature/association | entity/association | entity-feature/association">
        <xsl:choose>
            <xsl:when test="@id">
                <tr id="{@id}">
                    <td><xsl:value-of select="position()" /></td>
                    <td><xsl:apply-templates select="." mode="innerContent" /></td>
                </tr>
            </xsl:when>
            <xsl:otherwise>
                <tr>
                    <td><xsl:value-of select="position()" /></td>
                    <td><xsl:apply-templates select="." mode="innerContent" /></td>
                </tr>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>