<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- communicate associations -->

    <xsl:template match="use-case | segment" mode="table_of_contents_communicate_associations">
        <xsl:if test="communicate-association">
            <li>
                <a href="#{generate-id(.)}-communicate-associations" onclick="expandAncestors('{generate-id(.)}-communicate-associations')">
                    <xsl:choose>
                        <xsl:when test="count(communicate-association) = 1">Communicate associations</xsl:when>
                        <xsl:otherwise>Communicate association</xsl:otherwise>
                    </xsl:choose>
                </a>
            </li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="actor | use-case | segment" mode="communicate-associations">
        <xsl:if test="communicate-association">
            <h3 id="{generate-id(.)}-communicate-associations" onclick="toggleTag('{generate-id(.)}-communicate-associations')">
                <xsl:choose>
                    <xsl:when test="count(communicate-association) = 1">Communicate association</xsl:when>
                    <xsl:otherwise>Communicate associations</xsl:otherwise>
                </xsl:choose>
            </h3>
            <div id="{generate-id()}-communicate-associations" class="indent">
                <table class="communicate-associations">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>communicate-association</th>
                        </tr>
                    </thead>
                    <tbody>
                        <xsl:apply-templates select="communicate-association" />
                    </tbody>
                </table>
            </div>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>