<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
	<!-- alternative -->

    <xsl:template match="use-case | segment" mode="table_of_contents_alternatives">
        <xsl:if test="alternative">
            <li>
                <xsl:choose>
                    <xsl:when test="count(alternative) = 1">Alternative</xsl:when>
                    <xsl:otherwise>Alternatives</xsl:otherwise>
                </xsl:choose>
                <ul>
                    <xsl:for-each select="alternative">
                        <li><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></li>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>

  <xsl:template match="alternative">
	  <h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Alternative : <xsl:value-of select="@name" /></h3>
	  <div id="{generate-id(.)}" style="display:none" class="indent">
		  <xsl:apply-templates select="description" />
		  <xsl:apply-templates select="." mode="actors" />
          <xsl:apply-templates select="contract" />
		  <xsl:apply-templates select="narrative" />
	  </div>
  </xsl:template>

  <xsl:template match="alternative/description">
      <h3>Description</h3>
	  <div class="indent"><xsl:apply-templates /></div>  
  </xsl:template>
  
  <xsl:template match="alternative/narrative">
	  <h3 onclick="toggleAlgorithm('{generate-id(.)}')">Narrative</h3>
	  <ol id="{generate-id(.)}" state="collapsed" class="algorithm">
          <xsl:choose>
              <xsl:when test="../initiation/@when = 'instead'">
                  <li>The alternative scenario mey starts instead of the primary scenario</li>
              </xsl:when>
              <xsl:when test="../initiation/@when = 'after_step'">
                  <li>The alternative scenario starts after <xsl:value-of select="../initiation/@begin" /> step of the primary scenario</li>
              </xsl:when>
              <xsl:when test="../initiation/@when = 'in_any_moment'">
                  <li>The alternative scenario mey starts in any moment during performing the primary scenario</li>
              </xsl:when>
          </xsl:choose>
		  <xsl:apply-templates />
          <xsl:if test="../initiation/@when = 'after_step'  and ../initiation/@end">
                <li>The alternative scenario backs on <xsl:value-of select="../initiation/@end" /> step of the primary scenario</li>
          </xsl:if>
	  </ol>
      <xsl:if test="../initiation/@completion">
          <h3>Completion</h3>
          <div class="indent">
              <xsl:choose>
                  <xsl:when test="../initiation/@completion = 'fail'">The use case is terminated with the goal is unsatisfied</xsl:when>
                  <xsl:when test="../initiation/@completion = 'stop'">The use case is terminated with the goal is satisfied</xsl:when>
                  <xsl:otherwise><em class="comment"> { Warning :  The completion is undefined } </em></xsl:otherwise>
              </xsl:choose>
          </div>
      </xsl:if>
  </xsl:template>
	
</xsl:stylesheet>
