<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
    <!-- segment -->
    
    <xsl:template match="use-case | segment" mode="table_of_contents_segments">
        <xsl:if test="segment">
            <li>Segments
                <ul>
                    <xsl:for-each select="segment">
                        <li>
                            <xsl:choose>
                                <xsl:when test="@id">
                                    <a href="#{@id}" onclick="expandAncestors('{@id}')">Segment extends <xsl:value-of select="@extension-point" /> extension point</a>
                                </xsl:when>
                                <xsl:otherwise>
                                    <a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')">Segment extends <xsl:value-of select="@extension-point" /> extension point</a>
                                </xsl:otherwise>
                            </xsl:choose>
                            <xsl:apply-templates select="." mode="table_of_contents" />
                        </li>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="segment" mode="table_of_contents">
        <xsl:if test="specification or concretization or communicate-association or scenario or alternative or package or diagram or worker or entity or segment or use-case or test-scenarios">
            <ul>
                <xsl:apply-templates select="." mode="table_of_contents_overview" />
                <xsl:apply-templates select="." mode="table_of_contents_specification" />
                <xsl:apply-templates select="." mode="table_of_contents_concretization" />
                <xsl:apply-templates select="." mode="table_of_contents_communicate_associations" />
                <xsl:apply-templates select="." mode="table_of_contents_scenario" />
                <xsl:apply-templates select="." mode="table_of_contents_alternatives" />
                <xsl:apply-templates select="." mode="table_of_contents_packages" />
                <xsl:apply-templates select="." mode="table_of_contents_diagrams" />
                <xsl:apply-templates select="." mode="table_of_contents_workers" />
                <xsl:apply-templates select="." mode="table_of_contents_entities" />
                <xsl:apply-templates select="." mode="table_of_contents_use_cases" />
                <xsl:apply-templates select="." mode="table_of_contents_segments" />
                <xsl:apply-templates select="." mode="table_of_contents_test_scenarios" />
            </ul>
        </xsl:if>
    </xsl:template>
  
  <xsl:template match="use-case/segment | segment/segment">
    <xsl:choose>
        <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="name" /></h3></xsl:when>
        <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="name" /></h3></xsl:otherwise>
    </xsl:choose>
    <div id="{generate-id(.)}" style="display:none" class="indent">
        <xsl:apply-templates select="." mode="content" />
    </div>
  </xsl:template>
  
  <xsl:template match="segment" mode="name">
    Segment extends 
    <xsl:choose>
        <xsl:when test="@reference">
            <a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@extension-point" /></a>
        </xsl:when>
        <xsl:otherwise>
            <xsl:value-of select="@extension-point" />  
        </xsl:otherwise>
    </xsl:choose>
    extension point
  </xsl:template>
  
  <xsl:template match="segment/description">
    <h3>Description</h3>
    <div class="indent"><xsl:apply-templates /></div>
  </xsl:template>

</xsl:stylesheet>
