<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
    <!-- use-case and segment -->
    
	<xsl:template match="domain | package | use-case | segment" mode="table_of_contents_use_cases">
		<xsl:if test="use-case">
			<li>Use cases
				<ul>
					<xsl:for-each select="use-case">
						<li>
							<xsl:choose>
								<xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
								<xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
							</xsl:choose>
							<xsl:if test="specification or concretization or communicate-association or scenario or alternative or package or diagram or worker or entity or segment or use-case or test-scenarios">
								<ul>
							 		<xsl:apply-templates select="." mode="table_of_contents_overview" />
									<xsl:apply-templates select="." mode="table_of_contents_specification" />
                                    <xsl:apply-templates select="." mode="table_of_contents_concretization" />
                                    <xsl:apply-templates select="." mode="table_of_contents_communicate_associations" />
                                    <xsl:apply-templates select="." mode="table_of_contents_scenario" />
                                    <xsl:apply-templates select="." mode="table_of_contents_alternatives" />
									<xsl:apply-templates select="." mode="table_of_contents_packages" />
									<xsl:apply-templates select="." mode="table_of_contents_diagrams" />
									<xsl:apply-templates select="." mode="table_of_contents_workers" />
									<xsl:apply-templates select="." mode="table_of_contents_entities" />
							 		<xsl:apply-templates select="." mode="table_of_contents_use_cases" />
                                    <xsl:apply-templates select="." mode="table_of_contents_segments" />
                                    <xsl:apply-templates select="." mode="table_of_contents_test_scenarios" />
								</ul>
							</xsl:if>
						</li>	
					</xsl:for-each>
				</ul>
			</li>
		</xsl:if>
	</xsl:template>

  <xsl:template match="domain/use-case">
  		<xsl:choose>
  			<xsl:when test="@id"><h2 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="name" /></h2></xsl:when>
  			<xsl:otherwise><h2 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="name" /></h2></xsl:otherwise>
  		</xsl:choose>
        <div id="{generate-id(.)}" class="indent">
		    <xsl:apply-templates select="." mode="content" />
        </div>
  </xsl:template>

    <xsl:template match="use-case">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="name" /></h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="name" /></h3></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" class="indent">
            <xsl:apply-templates select="." mode="content" />
        </div>
    </xsl:template>

    <xsl:template match="use-case | segment" mode="content">
		<xsl:apply-templates select="description" />
 		<xsl:apply-templates select="." mode="overview" />
		<xsl:apply-templates select="specification" />
		<xsl:apply-templates select="concretization" />
        <xsl:apply-templates select="." mode="communicate-associations" />
        <xsl:apply-templates select="scenario" />
		<xsl:apply-templates select="alternative" />
		<xsl:apply-templates select="segment" />
		<xsl:apply-templates select="use-case" />
		<xsl:apply-templates select="package" />
		<xsl:apply-templates select="worker" />
		<xsl:apply-templates select="entity" />
		<xsl:apply-templates select="artifacts" />
        <xsl:apply-templates select="test-scenarios" />
		<xsl:apply-templates select="diagram" />
	</xsl:template>
  
  <xsl:template match="use-case" mode="name">
	<xsl:choose>
		<xsl:when test="@type='abstract'">Abstract use case : </xsl:when>
		<xsl:when test="@type='concrete'">Concrete use case : </xsl:when>
		<xsl:otherwise>Use case : </xsl:otherwise>
	</xsl:choose>
	<xsl:value-of select="@name" />
	<xsl:if test="@extends"> 
		extends
		<xsl:choose>
			<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@extends" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@extends" /></xsl:otherwise>
		</xsl:choose> 
	</xsl:if>
  </xsl:template>
  
  <xsl:template match="use-case/description">
    <h3>Description</h3>
    <div class="indent"><xsl:apply-templates /></div>
  </xsl:template>

</xsl:stylesheet>
