<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>
    <xsl:include href="common/htmlSubset.xslt" />
    <xsl:include href="evolution/iterations.xslt" />
    <xsl:include href="evolution/emotions.xslt" />
    <xsl:include href="evolution/activities.xslt" />
    <xsl:include href="evolution/estimates.xslt" />
    <xsl:include href="evolution/task.xslt" />
    <xsl:include href="evolution/risk.xslt" />

    <xsl:param name="out" as="xs:string" select="'memory'" />
  
  <xsl:template match="evolution">
<html>
    <head>
        <xsl:choose>
            <xsl:when test="@name"><title>Evolution : <xsl:value-of select="@name" /></title></xsl:when>
            <xsl:otherwise><title>Evolution</title></xsl:otherwise>
        </xsl:choose>
        <link rel="stylesheet" type="text/css" href=".blueprint/css/evolution.css" />
        <xsl:for-each select="stylesheet-link">
            <link rel="stylesheet" type="text/css" href="{@href}" />
        </xsl:for-each>
        <script type="text/javascript" src=".blueprint/js/evolution.js"></script>
    </head>
    <body onload="goToHash()">
        <xsl:choose>
          <xsl:when test="@name"><h1>Evolution : <xsl:value-of select="@name" /></h1></xsl:when>
          <xsl:otherwise><h1>Evolution</h1></xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="description" />
        <xsl:apply-templates select="." mode="table_of_contents" />
        <xsl:apply-templates select="iteration" />
        <xsl:apply-templates select="." mode="estimates" />
    </body>
</html>
  </xsl:template>

    <xsl:template match="evolution" mode="table_of_contents">
        <xsl:variable name="isTasks" as="xs:boolean" select="boolean(//task/@effort)" />
        <xsl:variable name="isRisks1" as="xs:boolean" select="boolean(//risk/@effort)" />
        <xsl:variable name="isRisks2" as="xs:boolean" select="boolean(//risk/@probability) and boolean(//risk/@impact)" />
        <xsl:variable name="isRisks3" as="xs:boolean" select="boolean(//risk/@score)" />
        <xsl:variable name="isEstimates" as="xs:boolean" select="$isTasks or $isRisks1 or $isRisks2 or $isRisks3" />
        <xsl:if test="iteration or $isEstimates">
            <h2>Table of contents</h2>
            <ul class="contents">
                <xsl:apply-templates select="." mode="table_of_contents_iterations" />
                <xsl:apply-templates select="." mode="table_of_contents_estimates" />
            </ul>
        </xsl:if>
    </xsl:template>

    <xsl:template match="evolution/description">
        <h2>Description</h2>
        <div class="indent">
            <xsl:apply-templates />
        </div>
    </xsl:template>

</xsl:stylesheet>
