<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- estimates -->

    <xsl:template match="evolution | iteration" mode="table_of_contents_estimates">
        <xsl:variable name="isTasks" as="xs:boolean" select="boolean(.//task/@effort)" />
        <xsl:variable name="isRisks1" as="xs:boolean" select="boolean(.//risk/@effort)" />
        <xsl:variable name="isRisks2" as="xs:boolean" select="boolean(.//risk/@probability) and boolean(.//risk/@impact)" />
        <xsl:variable name="isRisks3" as="xs:boolean" select="boolean(.//risk/@score)" />
        <xsl:variable name="isEstimates" as="xs:boolean" select="$isTasks or $isRisks1 or $isRisks2 or $isRisks3" />
        <xsl:if test="$isEstimates">
            <li><a href="#{generate-id(.)}-estimates-header" onclick="expandAncestors('estimates-header')">Estimates</a></li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="evolution" mode="estimates">
        <xsl:variable name="isTasks" as="xs:boolean" select="boolean(.//task/@effort)" />
        <xsl:variable name="isRisks1" as="xs:boolean" select="boolean(.//risk/@effort)" />
        <xsl:variable name="isRisks2" as="xs:boolean" select="boolean(.//risk/@probability) and boolean(.//risk/@impact)" />
        <xsl:variable name="isRisks3" as="xs:boolean" select="boolean(.//risk/@score)" />
        <xsl:variable name="isEstimates" as="xs:boolean" select="$isTasks or $isRisks1 or $isRisks2 or $isRisks3" />
        <xsl:if test="$isEstimates">
            <h2 id="{generate-id(.)}-estimates-header" onclick="toggleTag('{generate-id(.)}-estimates')">Estimates</h2>
            <div id="{generate-id(.)}-estimates" class="indent">
                <xsl:if test="$isTasks or $isRisks1 or $isRisks2 or $isRisks3">
                    <xsl:apply-templates select="." mode="estimates_initialize" />
                    <xsl:if test="$isTasks">
                        <xsl:apply-templates select="." mode="estimates_estimate" />
                    </xsl:if>
                    <xsl:if test="$isRisks1 or $isRisks2 or $isRisks3">
                        <xsl:apply-templates select="." mode="estimates_risk" />
                    </xsl:if>
                    <xsl:if test="$isTasks">
                        <xsl:apply-templates select="." mode="estimates_estimate_summary" />
                    </xsl:if>
                    <xsl:if test="$isRisks1 or $isRisks2 or $isRisks3">
                        <xsl:apply-templates select="." mode="estimates_risk_summary" />
                    </xsl:if>
                </xsl:if>
            </div>
        </xsl:if>
    </xsl:template>

    <xsl:template match="iteration" mode="estimates">
        <xsl:variable name="isTasks" as="xs:boolean" select="boolean(.//task/@effort)" />
        <xsl:variable name="isRisks1" as="xs:boolean" select="boolean(.//risk/@effort)" />
        <xsl:variable name="isRisks2" as="xs:boolean" select="boolean(.//risk/@probability) and boolean(.//risk/@impact)" />
        <xsl:variable name="isRisks3" as="xs:boolean" select="boolean(.//risk/@score)" />
        <xsl:variable name="isEstimates" as="xs:boolean" select="$isTasks or $isRisks1 or $isRisks2 or $isRisks3" />
        <xsl:if test="$isEstimates">
            <h3 id="{generate-id(.)}-estimates-header" onclick="toggleTag('{generate-id(.)}-estimates')">Estimates</h3>
            <div id="{generate-id(.)}-estimates" class="indent">
                <xsl:if test="$isTasks or $isRisks1 or $isRisks2 or $isRisks3">
                    <xsl:apply-templates select="." mode="estimates_initialize" />
                    <xsl:if test="$isTasks">
                        <xsl:apply-templates select="." mode="estimates_estimate" />
                    </xsl:if>
                    <xsl:if test="$isRisks1 or $isRisks2 or $isRisks3">
                        <xsl:apply-templates select="." mode="estimates_risk" />
                    </xsl:if>
                    <xsl:if test="$isTasks">
                        <xsl:apply-templates select="." mode="estimates_estimate_summary" />
                    </xsl:if>
                    <xsl:if test="$isRisks1 or $isRisks2 or $isRisks3">
                        <xsl:apply-templates select="." mode="estimates_risk_summary" />
                    </xsl:if>
                </xsl:if>
            </div>
        </xsl:if>
    </xsl:template>

    <xsl:template match="evolution | iteration" mode="estimates_initialize">
        <script type="text/javascript">
            /*
                b - maximum-effort
                w - minimum-effort
                m - effort
                c - estimate for current requirement
                e - full estimate
                p - divergence
                q - divergence for current requirement
                error(message, id)
                write(text)
                lr - estimate of low risks
                hr - estimate of high risks
                mr - estimate of medium risks
            */
            var estimatesId = "<xsl:value-of select="concat(generate-id(.), '-estimates')" />";
            function error(message, id) {
                var estimates = document.getElementById(estimatesId);
                var paragraph = document.createElement('div');
                var anchor = document.createElement('a');
                anchor.setAttribute("href", "#" + id);
                var node = document.createTextNode("" + message);
                anchor.appendChild(node);
                paragraph.appendChild(anchor);
                estimates.appendChild(paragraph);
            }
            var e = 0;
            var p = 0;
            var b, w, m, c, q = 0, isCorrect, id;
            var lr = 0;
            var hr = 0;
            var mr = 0;
            var score, probability, impact, effort;
            var measure =
            <xsl:choose>
                <xsl:when test="/evolution/@measure">"<xsl:value-of select="/evolution/@measure" />"</xsl:when>
                <xsl:otherwise>" developer days "</xsl:otherwise>
            </xsl:choose>
            ;
            var em =
            <xsl:choose>
                <xsl:when test="/evolution/@everyday-multiplier">parseFloat("<xsl:value-of select="/evolution/@everyday-multiplier" />")</xsl:when>
                <xsl:otherwise>2</xsl:otherwise>
            </xsl:choose>
            ;
            if (isNaN(em)) em = 2;
            var estimates = document.getElementById(estimatesId);
            function write(text) {
                var paragraph = document.createElement('p');
                var node = document.createTextNode("" + text);
                paragraph.appendChild(node);
                estimates.appendChild(paragraph);
            }
        </script>
    </xsl:template>

    <xsl:template match="evolution | iteration" mode="estimates_estimate">
        <script type="text/javascript">
            <xsl:for-each select=".//task">
                id =
                    <xsl:choose>
                        <xsl:when test="@id">"<xsl:value-of select="@id" />"</xsl:when>
                        <xsl:otherwise>"<xsl:value-of select="generate-id(.)" />"</xsl:otherwise>
                    </xsl:choose>
                ;
                isCorrect = true;
                <xsl:choose>
                    <xsl:when test="@effort and @minimum-effort and @maximum-effort" >
                        b = parseFloat('<xsl:value-of select="@maximum-effort" />');
                        w = parseFloat('<xsl:value-of select="@minimum-effort" />');
                        m = parseFloat('<xsl:value-of select="@effort" />');
                        if (isCorrect &amp;&amp; (isNaN(b) || (b &lt; 0))) {
                            isCorrect = false;
                            error('Error : the maximum effort is not defined', id);
                        }
                        if (isCorrect &amp;&amp; (isNaN(w) || (w &lt; 0))) {
                            isCorrect = false;
                            error('Error : the minimum effort is not defined', id);
                        }
                        if (isCorrect &amp;&amp; (isNaN(m) || (m &lt; 0))) {
                            isCorrect = false;
                            error('Error : the effort is not defined', id);
                        }
                        if (isCorrect &amp;&amp; (m &lt; w)) {
                            isCorrect = false;
                            error('Error : the effort is less then minimum effort', id);
                        }
                        if (isCorrect &amp;&amp; (b &lt; m)) {
                            isCorrect = false;
                            error('Error : the maximum effort is less then effort', id);
                        }
                        if (isCorrect) {
                            c = (w + 4 * m + b) / 6;
                            e = e + c;
                            q = (w - b) / 2
                            q = Math.pow(q, 2);
                            p = p + q;
                        }
                    </xsl:when>
                    <xsl:when test="@effort">
                        m = parseFloat('<xsl:value-of select="@effort" />');
                        if (isCorrect &amp;&amp; (isNaN(m) || (m &lt; 0))) {
                            isCorrect = false;
                            error('Error : the effort is not defined', id);
                        }
                        if (isCorrect) {
                            e = e + m;
                            q = Math.pow(m, 2);
                            p = p + q;
                        }
                    </xsl:when>
                    <xsl:otherwise>
                        error('Error : the effort is not defined', id);
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
            if (q &gt; 0) p = Math.sqrt(p);
        </script>
    </xsl:template>

    <xsl:template match="evolution | iteration" mode="estimates_risk">
        <script type="text/javascript">
            <xsl:for-each select=".//risk">
                id =
                    <xsl:choose>
                        <xsl:when test="@id">"<xsl:value-of select="@id" />"</xsl:when>
                        <xsl:otherwise>"<xsl:value-of select="generate-id(.)" />"</xsl:otherwise>
                    </xsl:choose>
                ;
                score = 0;
                effort = 0;
                isCorrect = true;
                <xsl:choose>
                    <xsl:when test="@probability and @impact">
                        probability = 0;
                        <xsl:choose>
                            <xsl:when test="@probability = 'very_likely'">
                                probability = 5;
                            </xsl:when>
                            <xsl:when test="@probability = 'probably'">
                                probability = 4;
                            </xsl:when>
                            <xsl:when test="@probability = 'may_occur'">
                                probability = 3;
                            </xsl:when>
                            <xsl:when test="@probability = 'unlikely'">
                                probability = 2;
                            </xsl:when>
                            <xsl:when test="@probability = 'very_unlikely'">
                                probability = 1;
                            </xsl:when>
                        </xsl:choose>
                        impact = 0;
                        <xsl:choose>
                            <xsl:when test="@impact = 'critical'">
                                impact = 10;
                            </xsl:when>
                            <xsl:when test="@impact = 'serious'">
                                impact = 8;
                            </xsl:when>
                            <xsl:when test="@impact = 'moderate'">
                                impact = 5;
                            </xsl:when>
                            <xsl:when test="@impact = 'minor'">
                                impact = 3;
                            </xsl:when>
                            <xsl:when test="@impact = 'negligible'">
                                impact = 1;
                            </xsl:when>
                        </xsl:choose>
                        score = probability * impact;
                    </xsl:when>
                    <xsl:when test="@score">
                        <xsl:choose>
                            <xsl:when test="@score = 'low'">
                                score = 10;
                            </xsl:when>
                            <xsl:when test="@score = 'medium'">
                                score = 30;
                            </xsl:when>
                            <xsl:when test="@score = 'high'">
                                score = 45;
                            </xsl:when>
                        </xsl:choose>
                    </xsl:when>
                </xsl:choose>
                <xsl:choose>
                    <xsl:when test="@effort">
                        effort = parseFloat('<xsl:value-of select="@effort" />');
                        if (isCorrect &amp;&amp; (isNaN(m) || (m &lt; 0))) {
                            isCorrect = false;
                            error('Error : the effort is not defined', id);
                        }
                    </xsl:when>
                    <xsl:otherwise>
                        isCorrect = false;
                        error('Error : the effort is not defined', id);
                    </xsl:otherwise>
                </xsl:choose>
                if (score &lt;= 0) {
                    isCorrect = false;
                    error('Error : the risk score is not defined', id);
                }
                if (isCorrect) {
                    if (score &lt; 20) lr += effort;
                    if (score &gt;= 20 &amp;&amp; score &lt; 40) mr += effort;
                    if (score &gt;= 40 &amp;&amp; score &lt;= 50) hr += effort;
                }
            </xsl:for-each>
        </script>
    </xsl:template>

    <xsl:template match="evolution | iteration" mode="estimates_estimate_summary">
        <script type="text/javascript">
            write("The most credible estimate is " + Math.round(em * e) + measure);
            write("The standard divergence is " + Math.round(em * p) + measure);
            write("The estimate will be between " + Math.round(em * (e - p)) + " and " + Math.round(em * (e + p)) + measure + " with authenticity 68%");
            write("The estimate will be between " + Math.round(em * (e - 2 * p)) + " and " + Math.round(em * (e + 2 * p)) + measure + " with authenticity 95%");
            write("The estimate will be between " + Math.round(em * (e - 3 * p)) + " and " + Math.round(em * (e + 3 * p)) + measure + " with authenticity 99.74%");
        </script>
    </xsl:template>

    <xsl:template match="evolution | iteration" mode="estimates_risk_summary">
        <script type="text/javascript">
            if (hr &gt; 0) write("The high risk exists of increasing the estimate by " + (em * hr) + measure);
            if (mr &gt; 0) write("The medium risk exists of increasing the estimate by " + (em * mr) + measure);
            if (lr &gt; 0) write("The low risk exists of increasing the estimate by " + (em * lr) + measure);
        </script>
    </xsl:template>

</xsl:stylesheet>
