<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2014 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" />

    <!-- scenario -->

    <xsl:template match="declaration" mode="table_of_contents_scenario">
        <xsl:if test="scenario">
            <li><a href="#{generate-id(scenario)}-header" onclick="expandAncestors('{generate-id(scenario)}-header')">Scenario</a></li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="model/use-case/declaration/scenario">
        <h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Scenario</h3>
        <xsl:apply-templates select="." mode="content" />
    </xsl:template>

    <xsl:template match="scenario">
        <h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Scenario</h4>
        <xsl:apply-templates select="." mode="content" />
    </xsl:template>

    <xsl:template match="scenario" mode="content">
        <div id="{generate-id(.)}" class="indent">
            <xsl:apply-templates select="description" />
            <xsl:apply-templates select="goal" />
            <xsl:apply-templates select="." mode="actors" />
            <xsl:apply-templates select="contract" />
            <xsl:apply-templates select="narrative" />
        </div>
    </xsl:template>

    <xsl:template match="scenario/description">
        <h4>Description</h4>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="scenario/goal">
        <h4>Goal</h4>
        <div class="indent"><xsl:apply-templates/></div>
    </xsl:template>

    <xsl:template match="scenario/narrative">
        <h4 onclick="toggleAlgorithm('{generate-id(.)}')">Narrative</h4>
        <ol id="{generate-id(.)}" state="collapsed" class="algorithm"><xsl:apply-templates/></ol>
    </xsl:template>

</xsl:stylesheet>
