<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" indent="yes"/>
	
  <!-- interface -->
  
  <xsl:template match="interface-section">
	  <h3>Interface</h3>
	  <div class="indent">
		<xsl:apply-templates select="description" />
	  	<xsl:apply-templates select="." mode="table_of_contents" />
		<xsl:apply-templates select="." mode="overview" />
		<xsl:apply-templates select="specification" />
		<xsl:apply-templates select="interface-package" />
        <xsl:apply-templates select="component-package" />
        <xsl:apply-templates select="diagram" />
        <xsl:apply-templates select="component" />
	  </div>
  </xsl:template>
  
  <xsl:template match="interface-package">
  	<xsl:choose>
  		<xsl:when test="@id"><h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h4></xsl:when>
  		<xsl:otherwise><h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h4></xsl:otherwise>
  	</xsl:choose>
  	<div id="{generate-id(.)}" class="indent" style="display:none">
		<xsl:apply-templates select="description" />
	  	<xsl:apply-templates select="." mode="table_of_contents" />
		<xsl:apply-templates select="." mode="overview" />
		<xsl:apply-templates select="specification" />
		<xsl:apply-templates select="interface-package" />
        <xsl:apply-templates select="component-package" />
        <xsl:apply-templates select="diagram" />
        <xsl:apply-templates select="component" />
  	</div>
  </xsl:template>
  
   <xsl:template match="interface-section/description | interface-package/description">
    <h4>Description</h4>
    <div class="indent"><xsl:apply-templates /></div>
  </xsl:template>

    <!-- table of contents -->
  
  <xsl:template match="interface-section" mode="table_of_contents">
	<h4>Table of contents</h4>
	<ul class="contents">
		<xsl:apply-templates select="." mode="table_of_contents_overview" />
		<xsl:apply-templates select="." mode="table_of_contents_specification" />
		<xsl:apply-templates select="." mode="table_of_contents_packages" />
        <xsl:apply-templates select="." mode="table_of_contents_diagrams" />
        <xsl:apply-templates select="." mode="table_of_contents_components" />
	 	<li><a href="#implementation" onclick="expandAncestors('implementation')">Implementation</a></li>
	</ul>
  </xsl:template>
  
  <xsl:template match="interface-package" mode="table_of_contents">
	<h4>Table of contents</h4>
	<ul class="contents">
		<xsl:apply-templates select="." mode="table_of_contents_overview" />
		<xsl:apply-templates select="." mode="table_of_contents_specification" />
		<xsl:apply-templates select="." mode="table_of_contents_packages" />
        <xsl:apply-templates select="." mode="table_of_contents_diagrams" />
        <xsl:apply-templates select="." mode="table_of_contents_components" />
	</ul>
  </xsl:template>
    
  <xsl:template match="interface-section | interface-package" mode="table_of_contents_packages">
	<xsl:if test="interface-package or component-package">
		<li>Packages
			<ul>
				<xsl:for-each select="interface-package">
					<li>
						<xsl:choose>
							<xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
							<xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
						</xsl:choose>
					</li>
				</xsl:for-each>
                <xsl:for-each select="component-package">
                    <xsl:variable name="reference" select="@reference" />
                    <xsl:variable name="cid" select="generate-id(.)" />
                    <xsl:for-each select="//package[@id = $reference]">
                        <xsl:variable name="id" select="concat($cid, generate-id(.), '-header-component-package')" as="xs:string" />
                        <li><a href="#{$id}" onclick="expandAncestors('{$id}')"><xsl:value-of select="@name" /></a></li>
                    </xsl:for-each>
                </xsl:for-each>
			</ul>
		</li>
	</xsl:if>
  </xsl:template>

    <xsl:template match="interface-section | interface-package" mode="table_of_contents_components">
        <xsl:if test="component">
            <li>Components
                <ul>
                    <xsl:for-each select="component">
                        <li>
                            <xsl:variable name="id" select="generate-id(.)" />
                            <xsl:variable name="reference" select="@reference" />
                            <a href="#{$id}-header" onclick="expandAncestors('{$id}-header')">
                                <xsl:for-each select="//implementation/classes/interface[@id = $reference]"><xsl:value-of select="@name" /></xsl:for-each>
                                <xsl:for-each select="//package/classes/interface[@id = $reference]"><xsl:value-of select="@name" /></xsl:for-each>
                                <xsl:for-each select="//capsule/classes/interface[@id = $reference]"><xsl:value-of select="@name" /></xsl:for-each>
                                <xsl:for-each select="//implementation/classes/class[@id = $reference]"><xsl:value-of select="@name" /></xsl:for-each>
                                <xsl:for-each select="//package/classes/class[@id = $reference]"><xsl:value-of select="@name" /></xsl:for-each>
                                <xsl:for-each select="//capsule/classes/class[@id = $reference]"><xsl:value-of select="@name" /></xsl:for-each>
                            </a>
                        </li>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>

  <xsl:template match="interface-section | interface-package" mode="table_of_contents_diagrams">
	<xsl:if test="diagram">
		<li>Diagrams
			<ul>
				<xsl:for-each select="diagram">
					<li>
						<xsl:choose>
							<xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
							<xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
						</xsl:choose>
					</li>
				</xsl:for-each>
			</ul>
		</li>
	</xsl:if>
  </xsl:template>

  <!-- diagrams -->

  <xsl:template match="interface-section/diagram | interface-package/diagram">
	<xsl:choose>
		<xsl:when test="@id"><h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Diagram : <xsl:value-of select="@name" /></h4></xsl:when>
		<xsl:otherwise><h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Diagram : <xsl:value-of select="@name" /></h4></xsl:otherwise>
	</xsl:choose>
    <img id="{generate-id(.)}" alt="{@name}" src="{@image}" />
  </xsl:template>

</xsl:stylesheet>