<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" indent="yes"/>
	
    <!-- overview -->

    <!-- interface -->

    <xsl:template match="interface-section | interface-package" mode="table_of_contents_overview">
        <xsl:if test="interface-package or component-package or component">
            <li><a href="#{generate-id(.)}-overview-header" onclick="expandAncestors('{generate-id(.)}-overview-header')">Overview</a></li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="interface-section | interface-package" mode="overview">
        <xsl:if test="interface-package or component-package or component">
            <h4 id="{generate-id(.)}-overview-header" onclick="toggleTag('{generate-id(.)}-overview')">Overview</h4>
            <div id="{generate-id(.)}-overview" class="indent">
                <xsl:if test="interface-package or component-package">
                    <table class="overview">
                        <caption>Package - Description</caption>
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Description</th>
                            </tr>
                        </thead>
                        <tbody>
                            <xsl:apply-templates select="interface-package" mode="pd" />
                            <xsl:apply-templates select="component-package" mode="pd" />
                        </tbody>
                    </table>
                </xsl:if>
                <xsl:if test="component">
                    <table class="overview">
                        <caption>Class - Description</caption>
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Description</th>
                            </tr>
                        </thead>
                        <tbody>
                            <xsl:for-each select="component">
                                <xsl:variable name="id" select="generate-id(.)" />
                                <xsl:variable name="reference" select="@reference" />
                                <xsl:for-each select="//implementation/classes/interface[@id = $reference]">
                                     <xsl:apply-templates select="." mode="cd_component">
                                         <xsl:with-param name="id" select="$id" />
                                     </xsl:apply-templates>
                                </xsl:for-each>
                                <xsl:for-each select="//package/classes/interface[@id = $reference]">
                                    <xsl:apply-templates select="." mode="cd_component">
                                        <xsl:with-param name="id" select="$id" />
                                    </xsl:apply-templates>
                                </xsl:for-each>
                                <xsl:for-each select="//capsule/classes/interface[@id = $reference]">
                                    <xsl:apply-templates select="." mode="cd_component">
                                        <xsl:with-param name="id" select="$id" />
                                    </xsl:apply-templates>
                                </xsl:for-each>
                                <xsl:for-each select="//implementation/classes/class[@id = $reference]">
                                    <xsl:apply-templates select="." mode="cd_component">
                                        <xsl:with-param name="id" select="$id" />
                                    </xsl:apply-templates>
                                </xsl:for-each>
                                <xsl:for-each select="//package/classes/class[@id = $reference]">
                                    <xsl:apply-templates select="." mode="cd_component">
                                        <xsl:with-param name="id" select="$id" />
                                    </xsl:apply-templates>
                                </xsl:for-each>
                                <xsl:for-each select="//capsule/classes/class[@id = $reference]">
                                    <xsl:apply-templates select="." mode="cd_component">
                                        <xsl:with-param name="id" select="$id" />
                                    </xsl:apply-templates>
                                </xsl:for-each>
                            </xsl:for-each>
                        </tbody>
                    </table>
                </xsl:if>
            </div>
        </xsl:if>
    </xsl:template>

    <xsl:template match="interface-package" mode="pd">
        <tr>
            <td>
                <xsl:choose>
                    <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                    <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                </xsl:choose>
            </td>
            <td><xsl:apply-templates select="description" mode="overview" /></td>
        </tr>
    </xsl:template>

    <xsl:template match="interface-package/description" mode="overview">
        <xsl:apply-templates />
    </xsl:template>

    <xsl:template match="component-package" mode="pd">
        <xsl:variable name="id" select="generate-id(.)" />
        <xsl:variable name="reference" select="@reference" />
        <xsl:for-each select="//package[@id = $reference]">
            <tr>
                <td><a href="#{$id}{generate-id(.)}-header-component-package" onclick="expandAncestors('{$id}{generate-id(.)}-header-component-package')"><xsl:value-of select="@name" /></a></td>
                <td><xsl:apply-templates select="description" mode="overview" /></td>
            </tr>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="interface" mode="cd_component">
        <xsl:param name="id" required="yes" />
        <tr>
            <td><a href="#{$id}-header" onclick="expandAncestors('{$id}-header')"><xsl:apply-templates select="." mode="overview_name" /></a></td>
            <td><xsl:apply-templates select="description" mode="overview" /></td>
        </tr>
    </xsl:template>

    <xsl:template match="class" mode="cd_component">
        <xsl:param name="id" required="yes" />
        <tr>
            <td><a href="#{$id}-header" onclick="expandAncestors('{$id}-header')"><xsl:apply-templates select="." mode="overview_name" /></a></td>
            <td>
                <xsl:variable name="canPerform" select="feature or description" />
                <xsl:choose>
                    <xsl:when test="$canPerform">
                        <xsl:apply-templates select="description" mode="overview" />
                        <xsl:apply-templates select="feature" mode="description_overview" />
                    </xsl:when>
                    <xsl:otherwise>
                        <br />
                    </xsl:otherwise>
                </xsl:choose>
            </td>
        </tr>
    </xsl:template>

    <!-- inner component package -->

    <xsl:template match="package" mode="table_of_contents_overview_component_package">
        <xsl:param name="id" required="yes" />
        <xsl:if test="packages or classes">
            <li><a href="#{$id}{generate-id(.)}-overview-header-component-package" onclick="expandAncestors('{$id}{generate-id(.)}-overview-header-component-package')">Overview</a></li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="package" mode="overview_component_package">
        <xsl:param name="id" required="yes" />
        <xsl:if test="packages or classes">
            <h4 id="{$id}{generate-id(.)}-overview-header-component-package" onclick="toggleTag('{$id}{generate-id(.)}-overview-component-package')">Overview</h4>
            <div id="{$id}{generate-id(.)}-overview-component-package" class="indent">
                <xsl:if test="packages">
                    <table class="overview">
                        <caption>Package - Description</caption>
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Description</th>
                            </tr>
                        </thead>
                        <tbody>
                            <xsl:apply-templates select="packages/package" mode="pd_component_package">
                                <xsl:with-param name="id" select="$id" />
                            </xsl:apply-templates>
                        </tbody>
                    </table>
                </xsl:if>
                <xsl:if test="classes">
                    <table class="overview">
                        <caption>Class - Description</caption>
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Description</th>
                            </tr>
                        </thead>
                        <tbody>
                            <xsl:apply-templates select="classes" mode="overview_component_package">
                                <xsl:with-param name="id" select="$id" />
                            </xsl:apply-templates>
                        </tbody>
                    </table>
                </xsl:if>
            </div>
        </xsl:if>
    </xsl:template>

    <xsl:template match="package" mode="pd_component_package">
        <xsl:param name="id" required="yes" />
        <tr>
            <td><a href="#{$id}{generate-id(.)}-header-component-package" onclick="expandAncestors('{$id}{generate-id(.)}-header-component-package')"><xsl:value-of select="@name" /></a></td>
            <td><xsl:apply-templates select="description" mode="overview" /></td>
        </tr>
    </xsl:template>

    <xsl:template match="package/classes" mode="overview_component_package">
        <xsl:param name="id" required="yes" />
        <xsl:apply-templates mode="cd_component_package">
            <xsl:with-param name="id" select="$id" />
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template match="interface" mode="cd_component_package">
        <xsl:param name="id" required="yes" />
        <tr>
            <td><a href="#{$id}{generate-id(.)}-header-component-package" onclick="expandAncestors('{$id}{generate-id(.)}-header-component-package')"><xsl:apply-templates select="." mode="overview_name" /></a></td>
            <td><xsl:apply-templates select="description" mode="overview" /></td>
        </tr>
    </xsl:template>

    <xsl:template match="class" mode="cd_component_package">
        <xsl:param name="id" required="yes" />
        <tr>
            <td><a href="#{$id}{generate-id(.)}-header-component-package" onclick="expandAncestors('{$id}{generate-id(.)}-header-component-package')"><xsl:apply-templates select="." mode="overview_name" /></a></td>
            <td>
                <xsl:variable name="canPerform" select="feature or description" />
                <xsl:choose>
                    <xsl:when test="$canPerform">
                        <xsl:apply-templates select="description" mode="overview" />
                        <xsl:apply-templates select="feature" mode="description_overview" />
                    </xsl:when>
                    <xsl:otherwise>
                        <br />
                    </xsl:otherwise>
                </xsl:choose>
            </td>
        </tr>
    </xsl:template>

    <!-- implementation -->
  
  <xsl:template match="implementation" mode="table_of_contents_overview">
	<xsl:if test="packages or classes or capsules or functions or threads or test-procedures">
		<li><a href="#overview"  onclick="expandAncestors('overview')">Overview</a></li>
	</xsl:if>
  </xsl:template>
  
  <xsl:template match="implementation" mode="overview">
	<xsl:if test="packages or classes or capsules or functions or threads or test-procedures">
		<h3 id="overview" onclick="toggleTag('{generate-id(.)}-overview')">Overview</h3>
		<div id="{generate-id(.)}-overview" class="indent" style="display:none">
			<xsl:apply-templates select="." mode="overview_content" />
		</div>
  	</xsl:if>
  </xsl:template>
  
  <!-- package -->
  
  <xsl:template match="package" mode="table_of_contents_overview">
	<xsl:if test="packages or classes or capsules or functions or threads or test-procedures">
		<li><a href="#{generate-id(.)}-overview-header"  onclick="expandAncestors('{generate-id(.)}-overview-header')">Overview</a></li>
	</xsl:if>
  </xsl:template>
  
  <xsl:template match="package" mode="overview">
	<xsl:if test="packages or classes or capsules or functions or threads or test-procedures">
		<h4 id="{generate-id(.)}-overview-header" onclick="toggleTag('{generate-id(.)}-overview')">Overview</h4>
		<div id="{generate-id(.)}-overview" class="indent" style="display:none">
			<xsl:apply-templates select="." mode="overview_content" />
		</div>
  	</xsl:if>
  </xsl:template>
  
  <!-- common -->
  
    <xsl:template match="implementation | package" mode="overview_content">
        <xsl:apply-templates select="." mode="overview_packages" />
        <xsl:apply-templates select="." mode="overview_capsules" />
        <xsl:apply-templates select="." mode="overview_classes" />
        <xsl:apply-templates select="." mode="overview_functions" />
        <xsl:apply-templates select="." mode="overview_threads" />
        <xsl:apply-templates select="." mode="overview_test_procedures" />
    </xsl:template>
	
</xsl:stylesheet>