<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- artifacts -->

    <xsl:template match="process | package" mode="table_of_contents_artifacts">
        <xsl:if test="artifact">
            <li>Artifacts
                <ul>
                    <xsl:for-each select="artifact">
                        <li>
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="process/artifact">
        <xsl:choose>
            <xsl:when test="@id"><h2 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="header" /></h2></xsl:when>
            <xsl:otherwise><h2 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="header" /></h2></xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="." mode="content" />
    </xsl:template>

    <xsl:template match="artifact">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="header" /></h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="header" /></h3></xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="." mode="content" />
    </xsl:template>

    <xsl:template match="artifact" mode="content">
        <div id="{generate-id(.)}" class="indent">
            <xsl:choose>
                <xsl:when test="description and not(diagram) and not(co-owner) and not(using) and not(artifact)">
                    <xsl:apply-templates select="description" mode="onlyDescription" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="description" />
                    <xsl:apply-templates select="diagram" />
                    <xsl:apply-templates select="." mode="purpose" />
                    <xsl:apply-templates select="." mode="using" />
                    <xsl:apply-templates select="artifact" />
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>

    <xsl:template match="artifact" mode="header">
        <xsl:choose>
            <xsl:when test="@stereotype = 'file'">File</xsl:when>
            <xsl:when test="@stereotype = 'directory'">Directory</xsl:when>
            <xsl:when test="@stereotype = 'document'">Document</xsl:when>
            <xsl:when test="@stereotype = 'executable'">Executable</xsl:when>
            <xsl:when test="@stereotype = 'library'">Library</xsl:when>
            <xsl:when test="@stereotype = 'script'">Script</xsl:when>
            <xsl:when test="@stereotype = 'source'">Source</xsl:when>
            <xsl:when test="@stereotype = 'manifest'">Manifest</xsl:when>
            <xsl:when test="@stereotype = 'blueprint'">Blueprint</xsl:when>
            <xsl:otherwise>Artifact</xsl:otherwise>
        </xsl:choose>
        :
        <xsl:choose>
            <xsl:when test="@document and $out = 'memory'"><a href="{@document}"><xsl:value-of select="@name" /></a></xsl:when>
            <xsl:when test="@page and $out = 'file'"><a href="{@page}"><xsl:value-of select="@name" /></a></xsl:when>
            <xsl:otherwise><xsl:value-of select="@name" /></xsl:otherwise>
        </xsl:choose>
        <xsl:if test="@path"> ( <xsl:value-of select="@path" /> ) </xsl:if>
    </xsl:template>

    <xsl:template match="artifact/description">
        <h3>Description</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="artifact/description" mode="onlyDescription">
        <xsl:apply-templates />
    </xsl:template>

    <xsl:template match="artifact" mode="purpose">
        <xsl:if test="co-owner">
            <h3>Purpose</h3>
            <ul class="purpose">
                <xsl:apply-templates select="co-owner" />
            </ul>
        </xsl:if>
    </xsl:template>

    <xsl:template match="artifact/co-owner">
        <li>
            The
            <xsl:choose>
                <xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@worker" /></a></xsl:when>
                <xsl:otherwise><xsl:value-of select="@worker" /></xsl:otherwise>
            </xsl:choose>
            <xsl:value-of select="' '" />
            <xsl:value-of select="@using" />
            <xsl:value-of select="'.'" />
            <xsl:if test="@description">
                The description is <xsl:value-of select="@description" /><xsl:value-of select="'.'" />
            </xsl:if>
        </li>
    </xsl:template>

    <xsl:template match="artifact" mode="using">
        <xsl:if test="using">
            <h3>Using</h3>
            <ul class="using">
                <xsl:apply-templates select="using" />
            </ul>
        </xsl:if>
    </xsl:template>

    <xsl:template match="artifact/using">
        <li>
            It's
            <xsl:choose>
                <xsl:when test="@type = 'input'"> input to </xsl:when>
                <xsl:when test="@type = 'output'"> output from </xsl:when>
                <xsl:when test="@type = 'had_found'"> had found for next </xsl:when>
                <xsl:when test="@type = 'supplied_information'"> supplied information for next </xsl:when>
                <xsl:otherwise><xsl:value-of select="@type" /> for next </xsl:otherwise>
            </xsl:choose>
            <xsl:value-of select="' '" />
            <xsl:choose>
                <xsl:when test="count(activity) = 1">activity : </xsl:when>
                <xsl:otherwise>activities : </xsl:otherwise>
            </xsl:choose>
            <ul class="activities">
                <xsl:apply-templates select="activity" />
            </ul>
        </li>
    </xsl:template>

</xsl:stylesheet>