<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2014 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- package overview -->

    <xsl:template match="process | package" mode="overview_packages">
        <xsl:if test="package">
            <table class="overview">
                <caption>Package - Description</caption>
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Description</th>
                    </tr>
                </thead>
                <tbody>
                    <xsl:apply-templates select="package" mode="pd" />
                </tbody>
            </table>
        </xsl:if>
    </xsl:template>

    <!-- package - description -->

    <xsl:template match="package" mode="pd">
        <tr>
            <td>
                <xsl:choose>
                    <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                    <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                </xsl:choose>
            </td>
            <td><xsl:apply-templates select="description" mode="overview" /></td>
        </tr>
    </xsl:template>

    <xsl:template match="package/description" mode="overview">
        <xsl:apply-templates />
    </xsl:template>

</xsl:stylesheet>