<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- capabilities -->

    <xsl:template match="capabilities" mode="table_of_contents">
        <li><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')">Capabilities</a></li>
    </xsl:template>

    <xsl:template match="capabilities">
        <h2 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Capabilities</h2>
        <div id="{generate-id(.)}" class="indent">
            <xsl:apply-templates select="capability" />
        </div>
    </xsl:template>

    <xsl:template match="capability">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Capability</h3></xsl:when>
            <xsl:otherwise><h3 onclick="toggleTag('{generate-id(.)}')">Capability</h3></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" class="indent">
            <xsl:apply-templates select="benefit" />
            <xsl:apply-templates select="particularity" />
        </div>
    </xsl:template>

    <xsl:template match="capability/benefit">
        <h3>Benefit</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="particularity">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Particularity</h3></xsl:when>
            <xsl:otherwise><h3 onclick="toggleTag('{generate-id(.)}')">Particularity</h3></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" class="indent">
            <xsl:apply-templates select="description" />
            <xsl:apply-templates select="." mode="attributes" />
            <xsl:apply-templates select="assignment" />
            <xsl:apply-templates select="substantiation" />
            <xsl:apply-templates select="." mode="tracing" />
        </div>
    </xsl:template>

    <xsl:template match="particularity/description">
        <xsl:apply-templates />
    </xsl:template>

    <xsl:template match="particularity" mode="attributes">
        <xsl:if test="@status or @priority or @effort or @risk or @stability or @target-release or @benefit">
            <table id="{generate-id(.)}" class="particularity">
                <thead>
                    <tr>
                        <xsl:if test="@status"><th>status</th></xsl:if>
                        <xsl:if test="@priority"><th>priority</th></xsl:if>
                        <xsl:if test="@effort"><th>effort</th></xsl:if>
                        <xsl:if test="@risk"><th>risk</th></xsl:if>
                        <xsl:if test="@stability"><th>stability</th></xsl:if>
                        <xsl:if test="@benefit"><th>benefit</th></xsl:if>
                        <xsl:if test="@target-release"><th>target release</th></xsl:if>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <xsl:if test="@status"><td><xsl:value-of select="@status" /></td></xsl:if>
                        <xsl:if test="@priority">
                            <td>
                                <xsl:choose>
                                    <xsl:when test="@priority = 'mast_have'">mast have</xsl:when>
                                    <xsl:when test="@priority = 'should_have'">should have</xsl:when>
                                    <xsl:when test="@priority = 'could_have'">could have</xsl:when>
                                    <xsl:when test="@priority = 'want_to_have'">want to have</xsl:when>
                                </xsl:choose>
                            </td>
                        </xsl:if>
                        <xsl:if test="@effort"><td><xsl:value-of select="@effort" /></td></xsl:if>
                        <xsl:if test="@risk"><td><xsl:value-of select="@risk" /></td></xsl:if>
                        <xsl:if test="@stability"><td><xsl:value-of select="@stability" /></td></xsl:if>
                        <xsl:if test="@benefit"><td><xsl:value-of select="@benefit" /></td></xsl:if>
                        <xsl:if test="@target-release"><td><xsl:value-of select="@target-release" /></td></xsl:if>
                    </tr>
                </tbody>
            </table>
        </xsl:if>
    </xsl:template>

    <xsl:template match="particularity/assignment">
        <h3>Assignment</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="particularity/substantiation">
        <h3>Substantiation</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="particularity" mode="tracing">
        <xsl:if test="traced-from-position or traced-to-requirement">
            <h3 onclick="toggleTag('{generate-id(.)}-tracing')">Tracing</h3>
            <ol id="{generate-id(.)}-tracing" class="tracing">
                <xsl:apply-templates select="traced-from-position" />
                <xsl:apply-templates select="traced-to-requirement" />
            </ol>
        </xsl:if>
    </xsl:template>

    <xsl:template match="traced-from-position">
        <li>
            <xsl:choose>
                <xsl:when test="$out = 'file' and @page">
                    <a href="{@page}#{@reference}">
                        traced from position
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:when test="$out = 'memory' and @document">
                    <a href="{@document}#{@reference}">
                        traced from position
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a href="#{@reference}" onclick="expandAncestors('{@reference}')">
                        traced from position
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>

    <xsl:template match="traced-to-requirement">
        <li>
            <xsl:choose>
                <xsl:when test="$out = 'file' and @page">
                    <a href="{@page}#{@reference}">
                        traced to requirement
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:when test="$out = 'memory' and @document">
                    <a href="{@document}#{@reference}">
                        traced to requirement
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a href="#{@reference}" onclick="expandAncestors('{@reference}')">
                        traced to requirement
                        <xsl:if test="@description"> ( <xsl:value-of select="@description" /> ) </xsl:if>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>

</xsl:stylesheet>