<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2014 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- profile -->

    <xsl:template match="co-owner/profile">
        <h3 onclick="toggleTag('{generate-id(.)}')">Profile</h3>
        <div id="{generate-id(.)}" class="indent">
            <xsl:apply-templates select="representative" />
            <xsl:apply-templates select="sophistication" />
            <xsl:apply-templates select="responsibilities" />
            <xsl:apply-templates select="environment" />
            <xsl:apply-templates select="success-criteria" />
            <xsl:apply-templates select="involvement" />
            <xsl:apply-templates select="deliverables" />
            <xsl:apply-templates select="comments" />
        </div>
    </xsl:template>

    <xsl:template match="profile/representative">
        <h3>Representative</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="profile/sophistication">
        <h3>Sophistication</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="profile/responsibilities">
        <h3>Responsibilities</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="profile/environment">
        <h3>Environment</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="profile/success-criteria">
        <h3>Success criteria</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="profile/involvement">
        <h3>Involvement</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="profile/deliverables">
        <h3>Deliverables</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="profile/comments">
        <h3>Comments</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

</xsl:stylesheet>