<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- issues -->

    <xsl:template match="issues" mode="table_of_contents">
        <li><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')">Issues</a>
            <xsl:if test="issue-package">
                <ul>
                    <xsl:apply-templates select="issue-package" mode="table_of_contents" />
                </ul>
            </xsl:if>
        </li>
    </xsl:template>

    <xsl:template match="issue-package" mode="table_of_contents">
        <li>
            <xsl:choose>
                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
            </xsl:choose>
            <xsl:if test="issue-package">
                <ul>
                    <xsl:apply-templates select="issue-package" mode="table_of_contents" />
                </ul>
            </xsl:if>
        </li>
    </xsl:template>

    <xsl:template match="issues">
        <h2 id="{generate-id(.)}-header">Issues</h2>
        <ol class="issues">
            <xsl:apply-templates />
        </ol>
    </xsl:template>

    <xsl:template match="issue-package">
        <xsl:choose>
            <xsl:when test="@id">
                <li>
                    <span id="{@id}" class="issue-package" onclick="toggleTag('{generate-id(.)}')"><xsl:value-of select="@name"/></span>
                    <ol id="{generate-id(.)}" style="display:none">
                        <xsl:apply-templates />
                    </ol>
                </li>
            </xsl:when>
            <xsl:otherwise>
                <li>
                    <span id="{generate-id(.)}-header" class="issue-package" onclick="toggleTag('{generate-id(.)}')"><xsl:value-of select="@name"/></span>
                    <ol id="{generate-id(.)}" style="display:none">
                        <xsl:apply-templates />
                    </ol>
                </li>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>