<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- requirements -->

    <xsl:template match="functional-requirements" mode="table_of_contents">
        <li><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')">Functional requirements</a>
            <xsl:if test="requirement-package">
                <ul>
                    <xsl:apply-templates select="requirement-package" mode="table_of_contents" />
                </ul>
            </xsl:if>
        </li>
    </xsl:template>

    <xsl:template match="non-functional-requirements" mode="table_of_contents">
        <li><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')">Non-functional requirements</a>
            <xsl:if test="requirement-package">
                <ul>
                    <xsl:apply-templates select="requirement-package" mode="table_of_contents" />
                </ul>
            </xsl:if>
        </li>
    </xsl:template>

    <xsl:template match="requirement-package" mode="table_of_contents">
        <li>
            <xsl:choose>
                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
            </xsl:choose>
            <xsl:if test="requirement-package">
                <ul>
                    <xsl:apply-templates select="requirement-package" mode="table_of_contents" />
                </ul>
            </xsl:if>
        </li>
    </xsl:template>

    <xsl:template match="functional-requirements">
        <h2 id="{generate-id(.)}-header">Functional requirements</h2>
        <ol class="requirements">
            <xsl:apply-templates />
        </ol>
    </xsl:template>

    <xsl:template match="non-functional-requirements">
        <h2 id="{generate-id(.)}-header">Non-functional requirements</h2>
        <ol class="requirements">
            <xsl:apply-templates />
        </ol>
    </xsl:template>

    <xsl:template match="requirement-package">
        <xsl:choose>
            <xsl:when test="@id">
                <li>
                    <span id="{@id}" class="requirement-package" onclick="toggleTag('{generate-id(.)}')"><xsl:value-of select="@name"/></span>
                    <ol id="{generate-id(.)}" style="display:none">
                        <xsl:apply-templates />
                    </ol>
                </li>
            </xsl:when>
            <xsl:otherwise>
                <li>
                    <span id="{generate-id(.)}-header" class="requirement-package" onclick="toggleTag('{generate-id(.)}')"><xsl:value-of select="@name"/></span>
                    <ol id="{generate-id(.)}" style="display:none">
                        <xsl:apply-templates />
                    </ol>
                </li>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>