<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- families -->

    <xsl:template match="workspace | package" mode="table_of_contents_families">
        <xsl:if test="family">
            <li>Families
                <ul>
                    <xsl:for-each select="family">
                        <li>
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                            </xsl:choose>
                            <xsl:if test="project">
                                <ul>
                                    <xsl:apply-templates select="." mode="table_of_contents_projects" />
                                </ul>
                            </xsl:if>
                        </li>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="workspace/family">
        <xsl:choose>
            <xsl:when test="@id"><h2 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Family : <xsl:apply-templates select="." mode="name" /></h2></xsl:when>
            <xsl:otherwise><h2 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Family : <xsl:apply-templates select="." mode="name" /></h2></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" class="indent">
            <xsl:apply-templates select="description" />
            <xsl:apply-templates select="specification" />
            <xsl:apply-templates select="diagram" />
            <xsl:apply-templates select="project" />
        </div>
    </xsl:template>

    <xsl:template match="package/family">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Family : <xsl:apply-templates select="." mode="name" /></h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Family : <xsl:apply-templates select="." mode="name" /></h3></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" class="indent">
            <xsl:apply-templates select="description" />
            <xsl:apply-templates select="specification" />
            <xsl:apply-templates select="diagram" />
            <xsl:apply-templates select="project" />
        </div>
    </xsl:template>

    <xsl:template match="family" mode="name">
        <xsl:choose>
            <xsl:when test="$out = 'file'"><a href="{@page}"><xsl:value-of select="@name" /></a></xsl:when>
            <xsl:otherwise><a href="{@document}"><xsl:value-of select="@name" /></a></xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="family/description">
        <h3>Description</h3>
        <div class="indent">
            <xsl:apply-templates />
        </div>
    </xsl:template>

</xsl:stylesheet>