<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- overview -->

    <xsl:template match="workspace | package" mode="table_of_contents_overview">
        <xsl:if test="package or project or family">
            <li><a href="#{generate-id(.)}-overview-header"  onclick="expandAncestors('{generate-id(.)}-overview-header')">Overview</a></li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="workspace" mode="overview">
        <xsl:if test="package or project or family">
            <h2 id="{generate-id(.)}-overview-header" onclick="toggleTag('{generate-id(.)}-overview')">Overview</h2>
            <xsl:apply-templates select="." mode="overview_content" />
        </xsl:if>
    </xsl:template>

    <xsl:template match="package" mode="overview">
        <xsl:if test="package or project or family">
            <h3 id="{generate-id(.)}-overview-header" onclick="toggleTag('{generate-id(.)}-overview')">Overview</h3>
            <xsl:apply-templates select="." mode="overview_content" />
        </xsl:if>
    </xsl:template>

    <xsl:template match="workspace | package" mode="overview_content">
        <div id="{generate-id(.)}-overview" class="indent" style="display:none">
            <xsl:apply-templates select="." mode="overview_packages" />
            <xsl:apply-templates select="." mode="overview_families" />
            <xsl:apply-templates select="." mode="overview_projects" />
        </div>
    </xsl:template>

</xsl:stylesheet>