<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- packages -->

    <xsl:template match="workspace | package" mode="table_of_contents_packages">
        <xsl:if test="package">
            <li>Packages
                <ul>
                    <xsl:for-each select="package">
                        <li>
                            <xsl:choose>
                                <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="workspace/package">
        <xsl:choose>
            <xsl:when test="@id"><h2 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h2></xsl:when>
            <xsl:otherwise><h2 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h2></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" style="display:none" class="indent">
            <xsl:apply-templates select="description" />
            <xsl:apply-templates select="." mode="table_of_contents" />
            <xsl:apply-templates select="." mode="overview" />
            <xsl:apply-templates select="specification" />
            <xsl:apply-templates select="package" />
            <xsl:apply-templates select="diagram" />
            <xsl:apply-templates select="family" />
            <xsl:apply-templates select="project" />
        </div>
    </xsl:template>


    <xsl:template match="package/package">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h3></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" style="display:none" class="indent">
            <xsl:apply-templates select="description" />
            <xsl:apply-templates select="." mode="table_of_contents" />
            <xsl:apply-templates select="." mode="overview" />
            <xsl:apply-templates select="specification" />
            <xsl:apply-templates select="package" />
            <xsl:apply-templates select="diagram" />
            <xsl:apply-templates select="family" />
            <xsl:apply-templates select="project" />
        </div>
    </xsl:template>

    <xsl:template match="package/description">
        <h3>Description</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <xsl:template match="package" mode="table_of_contents">
        <xsl:if test="specification or package or diagram or project or family">
            <h3>Table of contents</h3>
            <ul class="contents">
                <xsl:apply-templates select="." mode="table_of_contents_overview" />
                <xsl:apply-templates select="." mode="table_of_contents_specification" />
                <xsl:apply-templates select="." mode="table_of_contents_packages" />
                <xsl:apply-templates select="." mode="table_of_contents_diagrams" />
                <xsl:apply-templates select="." mode="table_of_contents_families" />
                <xsl:apply-templates select="." mode="table_of_contents_projects" />
            </ul>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>