package neutrino.dialogs;

import neutrino.OpenList;
import neutrino.multitext.EditorAdapterFactory;
import neutrino.multitext.EditorType;
import neutrino.multitext.MultiTextComponent;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
import static javax.swing.JOptionPane.*;

/**
 * @author Oleh Radvanskyj
 * @version 1.0
 * Date: 9/30/15
 * Time: 12:30 AM
 */
public class EditorChooser {

    private class EditorMenu {

        private MultiTextComponent multiTextComponent;
        private JMenu mNewEditor;

        private class EditorMenuItem extends JMenuItem implements ActionListener {

            private EditorType type;

            public EditorMenuItem(EditorType type) {
                super(type.getName());
                this.type = type;
                addActionListener(this);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                multiTextComponent.newEditor(EditorAdapterFactory.createTextEditorAdapterForEditorType(type));
            }

        }

        private EditorMenuItem miPlainText = new EditorMenuItem(EditorType.PLAIN);
        private JMenu mDocument = new JMenu("Document");
        private EditorMenuItem miRTF = new EditorMenuItem(EditorType.RTF);
        private EditorMenuItem miWeb = new EditorMenuItem(EditorType.WEB);
        private JMenu mProgram = new JMenu("Program");
        private JMenu mSystemOriented = new JMenu("System Oriented");
        private EditorMenuItem miAssembler = new EditorMenuItem(EditorType.ASSEMBLER);
        private EditorMenuItem miC = new EditorMenuItem(EditorType.C);
        private EditorMenuItem miCPP = new EditorMenuItem(EditorType.CPP);
        private JMenu mProblemOriented = new JMenu("Problem Oriented");
        private EditorMenuItem miCSharp = new EditorMenuItem(EditorType.CSHARP);
        private EditorMenuItem miPascal = new EditorMenuItem(EditorType.PASCAL);
        private EditorMenuItem miFortran = new EditorMenuItem(EditorType.FORTRAN);
        private EditorMenuItem miJava = new EditorMenuItem(EditorType.JAVA);
        private EditorMenuItem miLisp = new EditorMenuItem(EditorType.LISP);
        private EditorMenuItem miPerl = new EditorMenuItem(EditorType.PERL);
        private EditorMenuItem miPython = new EditorMenuItem(EditorType.PYTHON);
        private EditorMenuItem miBasic = new EditorMenuItem(EditorType.BASIC);
        private EditorMenuItem miClojure = new EditorMenuItem(EditorType.CLOJURE);
        private EditorMenuItem miGroovy = new EditorMenuItem(EditorType.GROOVY);
        private EditorMenuItem miLua = new EditorMenuItem(EditorType.LUA);
        private EditorMenuItem miScala = new EditorMenuItem(EditorType.SCALA);
        private JMenu mWebApplication = new JMenu("Web Application");
        private JMenu mServerSide = new JMenu("Server Side");
        private EditorMenuItem miJSP = new EditorMenuItem(EditorType.JSP);
        private EditorMenuItem miPHP = new EditorMenuItem(EditorType.PHP);
        private EditorMenuItem miRuby = new EditorMenuItem(EditorType.RUBY);
        private JMenu mClientSide = new JMenu("Client Side");
        private EditorMenuItem miHTML = new EditorMenuItem(EditorType.HTML);
        private EditorMenuItem miCSS = new EditorMenuItem(EditorType.CSS);
        private EditorMenuItem miJavaScript = new EditorMenuItem(EditorType.JAVASCRIPT);
        private JMenu mFlex = new JMenu("Flex");
        private EditorMenuItem miActionScript = new EditorMenuItem(EditorType.ACTIONSCRIPT);
        private EditorMenuItem miMXML = new EditorMenuItem(EditorType.MXML);
        private JMenu mData = new JMenu("Data");
        private EditorMenuItem miDTD = new EditorMenuItem(EditorType.DTD);
        private EditorMenuItem miXML = new EditorMenuItem(EditorType.XML);
        private EditorMenuItem miJSON = new EditorMenuItem(EditorType.JSON);
        private EditorMenuItem miBBCode = new EditorMenuItem(EditorType.BBCODE);
        private JMenu mDatabase = new JMenu("Database");
        private EditorMenuItem miSQL = new EditorMenuItem(EditorType.SQL);
        private EditorMenuItem miSAS = new EditorMenuItem(EditorType.SAS);
        private JMenu mScript = new JMenu("Script");
        private EditorMenuItem miLaTeX = new EditorMenuItem(EditorType.LATEX);
        private EditorMenuItem miMake = new EditorMenuItem(EditorType.MAKE);
        private EditorMenuItem miProperties = new EditorMenuItem(EditorType.PROPERTIES);
        private EditorMenuItem miTcl = new EditorMenuItem(EditorType.TCL);
        private EditorMenuItem miShell = new EditorMenuItem(EditorType.SHELL);
        private EditorMenuItem miBatch = new EditorMenuItem(EditorType.BATCH);
        private EditorMenuItem miNSIS = new EditorMenuItem(EditorType.NSIS);

        private void buildMenu() {
            mNewEditor.add(miPlainText);
            mNewEditor.add(mDocument);
            mDocument.add(miRTF);
            mDocument.add(miWeb);
            mNewEditor.add(mProgram);
            mProgram.add(mSystemOriented);
            mSystemOriented.add(miAssembler);
            mSystemOriented.add(miC);
            mSystemOriented.add(miCPP);
            mProgram.add(mProblemOriented);
            mProblemOriented.add(miCSharp);
            mProblemOriented.add(miPascal);
            mProblemOriented.add(miFortran);
            mProblemOriented.add(miJava);
            mProblemOriented.add(miLisp);
            mProblemOriented.add(miPerl);
            mProblemOriented.add(miPython);
            mProblemOriented.add(miBasic);
            mProblemOriented.add(miClojure);
            mProblemOriented.add(miGroovy);
            mProblemOriented.add(miLua);
            mProblemOriented.add(miScala);
            mNewEditor.add(mWebApplication);
            mWebApplication.add(mServerSide);
            mServerSide.add(miJSP);
            mServerSide.add(miPHP);
            mServerSide.add(miRuby);
            mWebApplication.add(mClientSide);
            mClientSide.add(miHTML);
            mClientSide.add(miCSS);
            mClientSide.add(miJavaScript);
            mClientSide.add(mFlex);
            mFlex.add(miActionScript);
            mFlex.add(miMXML);
            mWebApplication.add(mData);
            mData.add(miDTD);
            mData.add(miXML);
            mData.add(miJSON);
            mData.add(miBBCode);
            mNewEditor.add(mDatabase);
            mDatabase.add(miSQL);
            mDatabase.add(miSAS);
            mNewEditor.add(mScript);
            mScript.add(miLaTeX);
            mScript.add(miMake);
            mScript.add(miProperties);
            mScript.add(miTcl);
            mScript.add(miShell);
            mScript.add(miBatch);
            mScript.add(miNSIS);
        }

        private void buildMnemonics() {
            miPlainText.setMnemonic(KeyEvent.VK_P);
            mDocument.setMnemonic(KeyEvent.VK_D);
            miRTF.setMnemonic(KeyEvent.VK_R);
            miWeb.setMnemonic(KeyEvent.VK_W);
            mProgram.setMnemonic(KeyEvent.VK_P);
            mSystemOriented.setMnemonic(KeyEvent.VK_S);
            miAssembler.setMnemonic(KeyEvent.VK_A);
            miC.setMnemonic(KeyEvent.VK_C);
            miCPP.setMnemonic(KeyEvent.VK_PLUS);
            mProblemOriented.setMnemonic(KeyEvent.VK_P);
            miCSharp.setMnemonic(KeyEvent.VK_C);
            miPascal.setMnemonic(KeyEvent.VK_P);
            miFortran.setMnemonic(KeyEvent.VK_F);
            miJava.setMnemonic(KeyEvent.VK_J);
            miLisp.setMnemonic(KeyEvent.VK_L);
            miPerl.setMnemonic(KeyEvent.VK_E);
            miPython.setMnemonic(KeyEvent.VK_Y);
            miBasic.setMnemonic(KeyEvent.VK_B);
            miClojure.setMnemonic(KeyEvent.VK_O);
            miGroovy.setMnemonic(KeyEvent.VK_G);
            miLua.setMnemonic(KeyEvent.VK_U);
            miScala.setMnemonic(KeyEvent.VK_S);
            mWebApplication.setMnemonic(KeyEvent.VK_W);
            mServerSide.setMnemonic(KeyEvent.VK_S);
            miJSP.setMnemonic(KeyEvent.VK_P);
            miPHP.setMnemonic(KeyEvent.VK_H);
            miRuby.setMnemonic(KeyEvent.VK_R);
            mClientSide.setMnemonic(KeyEvent.VK_C);
            miHTML.setMnemonic(KeyEvent.VK_M);
            miCSS.setMnemonic(KeyEvent.VK_C);
            miJavaScript.setMnemonic(KeyEvent.VK_J);
            mFlex.setMnemonic(KeyEvent.VK_F);
            miActionScript.setMnemonic(KeyEvent.VK_A);
            miMXML.setMnemonic(KeyEvent.VK_M);
            mData.setMnemonic(KeyEvent.VK_D);
            miDTD.setMnemonic(KeyEvent.VK_D);
            miXML.setMnemonic(KeyEvent.VK_X);
            miJSON.setMnemonic(KeyEvent.VK_S);
            miBBCode.setMnemonic(KeyEvent.VK_B);
            mDatabase.setMnemonic(KeyEvent.VK_D);
            miSQL.setMnemonic(KeyEvent.VK_S);
            miSAS.setMnemonic(KeyEvent.VK_A);
            mScript.setMnemonic(KeyEvent.VK_S);
            miLaTeX.setMnemonic(KeyEvent.VK_L);
            miMake.setMnemonic(KeyEvent.VK_M);
            miProperties.setMnemonic(KeyEvent.VK_P);
            miTcl.setMnemonic(KeyEvent.VK_T);
            miShell.setMnemonic(KeyEvent.VK_S);
            miBatch.setMnemonic(KeyEvent.VK_B);
            miNSIS.setMnemonic(KeyEvent.VK_N);
        }

        public EditorMenu(MultiTextComponent multiTextComponent) {
            this.multiTextComponent = multiTextComponent;
            mNewEditor = new JMenu("New Editor");
            mNewEditor.setMnemonic(KeyEvent.VK_N);
            buildMenu();
            buildMnemonics();
        }

        public JMenu getMenu() {
            return this.mNewEditor;
        }

    }

    private class EditorDialog extends JDialog implements ActionListener {
        
        private class EditorMenuItem extends JMenuItem implements ActionListener {
            
            private EditorType type;
            
            public EditorMenuItem(EditorType type) {
                super(type.getName());
                this.type = type;
                addActionListener(this);
                
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                olEditor.setSelectedValue(type.getName());
            }

        }

        private JButton bOk = new JButton("Ok");
        private JButton bCancel = new JButton("Cancel");
        private JButton bDefault = new JButton("Default");
        private JButton bSelect = new JButton("Select");
        private OpenList olEditor = new OpenList();
        private JPanel pEditor = new JPanel(new GridLayout(1, 1, 1, 5));
        private int option = JOptionPane.CANCEL_OPTION;
        private EditorType editor = null;
        private EditorType defaultEditor = EditorType.PLAIN;
        private JPopupMenu pmEditor = new JPopupMenu();

        private EditorMenuItem miPlainText = new EditorMenuItem(EditorType.PLAIN);
        private JMenu mDocument = new JMenu("Document");
        private EditorMenuItem miRTF = new EditorMenuItem(EditorType.RTF);
        private EditorMenuItem miWeb = new EditorMenuItem(EditorType.WEB);
        private JMenu mProgram = new JMenu("Program");
        private JMenu mSystemOriented = new JMenu("System Oriented");
        private EditorMenuItem miAssembler = new EditorMenuItem(EditorType.ASSEMBLER);
        private EditorMenuItem miC = new EditorMenuItem(EditorType.C);
        private EditorMenuItem miCPP = new EditorMenuItem(EditorType.CPP);
        private JMenu mProblemOriented = new JMenu("Problem Oriented");
        private EditorMenuItem miCSharp = new EditorMenuItem(EditorType.CSHARP);
        private EditorMenuItem miPascal = new EditorMenuItem(EditorType.PASCAL);
        private EditorMenuItem miFortran = new EditorMenuItem(EditorType.FORTRAN);
        private EditorMenuItem miJava = new EditorMenuItem(EditorType.JAVA);
        private EditorMenuItem miLisp = new EditorMenuItem(EditorType.LISP);
        private EditorMenuItem miPerl = new EditorMenuItem(EditorType.PERL);
        private EditorMenuItem miPython = new EditorMenuItem(EditorType.PYTHON);
        private EditorMenuItem miBasic = new EditorMenuItem(EditorType.BASIC);
        private EditorMenuItem miClojure = new EditorMenuItem(EditorType.CLOJURE);
        private EditorMenuItem miGroovy = new EditorMenuItem(EditorType.GROOVY);
        private EditorMenuItem miLua = new EditorMenuItem(EditorType.LUA);
        private EditorMenuItem miScala = new EditorMenuItem(EditorType.SCALA);
        private JMenu mWebApplication = new JMenu("Web Application");
        private JMenu mServerSide = new JMenu("Server Side");
        private EditorMenuItem miJSP = new EditorMenuItem(EditorType.JSP);
        private EditorMenuItem miPHP = new EditorMenuItem(EditorType.PHP);
        private EditorMenuItem miRuby = new EditorMenuItem(EditorType.RUBY);
        private JMenu mClientSide = new JMenu("Client Side");
        private EditorMenuItem miHTML = new EditorMenuItem(EditorType.HTML);
        private EditorMenuItem miCSS = new EditorMenuItem(EditorType.CSS);
        private EditorMenuItem miJavaScript = new EditorMenuItem(EditorType.JAVASCRIPT);
        private JMenu mFlex = new JMenu("Flex");
        private EditorMenuItem miActionScript = new EditorMenuItem(EditorType.ACTIONSCRIPT);
        private EditorMenuItem miMXML = new EditorMenuItem(EditorType.MXML);
        private JMenu mData = new JMenu("Data");
        private EditorMenuItem miDTD = new EditorMenuItem(EditorType.DTD);
        private EditorMenuItem miXML = new EditorMenuItem(EditorType.XML);
        private EditorMenuItem miJSON = new EditorMenuItem(EditorType.JSON);
        private EditorMenuItem miBBCode = new EditorMenuItem(EditorType.BBCODE);
        private JMenu mDatabase = new JMenu("Database");
        private EditorMenuItem miSQL = new EditorMenuItem(EditorType.SQL);
        private EditorMenuItem miSAS = new EditorMenuItem(EditorType.SAS);
        private JMenu mScript = new JMenu("Script");
        private EditorMenuItem miLaTeX = new EditorMenuItem(EditorType.LATEX);
        private EditorMenuItem miMake = new EditorMenuItem(EditorType.MAKE);
        private EditorMenuItem miProperties = new EditorMenuItem(EditorType.PROPERTIES);
        private EditorMenuItem miTcl = new EditorMenuItem(EditorType.TCL);
        private EditorMenuItem miShell = new EditorMenuItem(EditorType.SHELL);
        private EditorMenuItem miBatch = new EditorMenuItem(EditorType.BATCH);
        private EditorMenuItem miNSIS = new EditorMenuItem(EditorType.NSIS);
        private JMenuItem miHide = new JMenuItem("Hide");

        private void buildMenu() {
            pmEditor.add(miPlainText);
            pmEditor.add(mDocument);
            mDocument.add(miRTF);
            mDocument.add(miWeb);
            pmEditor.add(mProgram);
            mProgram.add(mSystemOriented);
            mSystemOriented.add(miAssembler);
            mSystemOriented.add(miC);
            mSystemOriented.add(miCPP);
            mProgram.add(mProblemOriented);
            mProblemOriented.add(miCSharp);
            mProblemOriented.add(miPascal);
            mProblemOriented.add(miFortran);
            mProblemOriented.add(miJava);
            mProblemOriented.add(miLisp);
            mProblemOriented.add(miPerl);
            mProblemOriented.add(miPython);
            mProblemOriented.add(miBasic);
            mProblemOriented.add(miClojure);
            mProblemOriented.add(miGroovy);
            mProblemOriented.add(miLua);
            mProblemOriented.add(miScala);
            pmEditor.add(mWebApplication);
            mWebApplication.add(mServerSide);
            mServerSide.add(miJSP);
            mServerSide.add(miPHP);
            mServerSide.add(miRuby);
            mWebApplication.add(mClientSide);
            mClientSide.add(miHTML);
            mClientSide.add(miCSS);
            mClientSide.add(miJavaScript);
            mClientSide.add(mFlex);
            mFlex.add(miActionScript);
            mFlex.add(miMXML);
            mWebApplication.add(mData);
            mData.add(miDTD);
            mData.add(miXML);
            mData.add(miJSON);
            mData.add(miBBCode);
            pmEditor.add(mDatabase);
            mDatabase.add(miSQL);
            mDatabase.add(miSAS);
            pmEditor.add(mScript);
            mScript.add(miLaTeX);
            mScript.add(miMake);
            mScript.add(miProperties);
            mScript.add(miTcl);
            mScript.add(miShell);
            mScript.add(miBatch);
            mScript.add(miNSIS);
            pmEditor.add(miHide);
        }

        private void buildMnemonics() {
            miPlainText.setMnemonic(KeyEvent.VK_P);
            mDocument.setMnemonic(KeyEvent.VK_D);
            miRTF.setMnemonic(KeyEvent.VK_R);
            miWeb.setMnemonic(KeyEvent.VK_W);
            mProgram.setMnemonic(KeyEvent.VK_P);
            mSystemOriented.setMnemonic(KeyEvent.VK_S);
            miAssembler.setMnemonic(KeyEvent.VK_A);
            miC.setMnemonic(KeyEvent.VK_C);
            miCPP.setMnemonic(KeyEvent.VK_PLUS);
            mProblemOriented.setMnemonic(KeyEvent.VK_P);
            miCSharp.setMnemonic(KeyEvent.VK_C);
            miPascal.setMnemonic(KeyEvent.VK_P);
            miFortran.setMnemonic(KeyEvent.VK_F);
            miJava.setMnemonic(KeyEvent.VK_J);
            miLisp.setMnemonic(KeyEvent.VK_L);
            miPerl.setMnemonic(KeyEvent.VK_E);
            miPython.setMnemonic(KeyEvent.VK_Y);
            miBasic.setMnemonic(KeyEvent.VK_B);
            miClojure.setMnemonic(KeyEvent.VK_O);
            miGroovy.setMnemonic(KeyEvent.VK_G);
            miLua.setMnemonic(KeyEvent.VK_U);
            miScala.setMnemonic(KeyEvent.VK_S);
            mWebApplication.setMnemonic(KeyEvent.VK_W);
            mServerSide.setMnemonic(KeyEvent.VK_S);
            miJSP.setMnemonic(KeyEvent.VK_P);
            miPHP.setMnemonic(KeyEvent.VK_H);
            miRuby.setMnemonic(KeyEvent.VK_R);
            mClientSide.setMnemonic(KeyEvent.VK_C);
            miHTML.setMnemonic(KeyEvent.VK_M);
            miCSS.setMnemonic(KeyEvent.VK_C);
            miJavaScript.setMnemonic(KeyEvent.VK_J);
            mFlex.setMnemonic(KeyEvent.VK_F);
            miActionScript.setMnemonic(KeyEvent.VK_A);
            miMXML.setMnemonic(KeyEvent.VK_M);
            mData.setMnemonic(KeyEvent.VK_D);
            miDTD.setMnemonic(KeyEvent.VK_D);
            miXML.setMnemonic(KeyEvent.VK_X);
            miJSON.setMnemonic(KeyEvent.VK_S);
            miBBCode.setMnemonic(KeyEvent.VK_B);
            mDatabase.setMnemonic(KeyEvent.VK_D);
            miSQL.setMnemonic(KeyEvent.VK_S);
            miSAS.setMnemonic(KeyEvent.VK_A);
            mScript.setMnemonic(KeyEvent.VK_S);
            miLaTeX.setMnemonic(KeyEvent.VK_L);
            miMake.setMnemonic(KeyEvent.VK_M);
            miProperties.setMnemonic(KeyEvent.VK_P);
            miTcl.setMnemonic(KeyEvent.VK_T);
            miShell.setMnemonic(KeyEvent.VK_S);
            miBatch.setMnemonic(KeyEvent.VK_B);
            miNSIS.setMnemonic(KeyEvent.VK_N);
        }

        private JPanel getMainPanel() {
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.gridheight = 5;
            c.insets = new Insets(5, 5, 5, 5);
            c.fill = GridBagConstraints.BOTH;
            panel.add(pEditor, c);
            c.gridx = 1;
            c.gridy = 0;
            c.gridheight = 1;
            c.insets = new Insets(10, 0, 0, 5);
            c.fill = GridBagConstraints.HORIZONTAL;
            panel.add(bOk, c);
            c.gridx = 1;
            c.gridy = 1;
            c.gridheight = 1;
            c.insets = new Insets(5, 0, 0, 5);
            c.fill = GridBagConstraints.HORIZONTAL;
            panel.add(bCancel, c);
            c.gridx = 1;
            c.gridy = 2;
            c.gridheight = 1;
            c.insets = new Insets(5, 0, 0, 5);
            c.fill = GridBagConstraints.HORIZONTAL;
            panel.add(bDefault, c);
            c.gridx = 1;
            c.gridy = 3;
            c.gridheight = 1;
            c.insets = new Insets(5, 0, 0, 5);
            c.fill = GridBagConstraints.HORIZONTAL;
            panel.add(bSelect, c);
            return panel;
        }

        private void initEditorList() {
            EditorType[] types = EditorType.values();
            Vector<String> listData = new Vector<String>();
            for (int i = 0; i < types.length; i++) {
                listData.add(types[i].getName());
            }
            olEditor.setListData(listData, true);
        }

        private void buildButtonMnemonics() {
            bOk.setMnemonic(KeyEvent.VK_O);
            bCancel.setMnemonic(KeyEvent.VK_C);
            bDefault.setMnemonic(KeyEvent.VK_D);
            bSelect.setMnemonic(KeyEvent.VK_S);
        }

        private void buildButtonListeners() {
            bOk.addActionListener(this);
            bCancel.addActionListener(this);
            bDefault.addActionListener(this);
            bSelect.addActionListener(this);
        }

        private void buildButtonToolTipTexts() {
            bOk.setToolTipText("Open editor");
            bCancel.setToolTipText("Abort editor choosing dialog");
            bDefault.setToolTipText("Select default editor");
            bSelect.setToolTipText("Select editor from menu");
        }

        public EditorDialog(String title) {
            super();
            setTitle(title);
            setModal(true);
            setResizable(false);
            setDefaultCloseOperation(DISPOSE_ON_CLOSE);
            getRootPane().setDefaultButton(bOk);
            buildButtonMnemonics();
            buildButtonListeners();
            buildButtonToolTipTexts();
            olEditor.setSize(new Dimension(200, 230));
            olEditor.setFixedSelectedValue(true);
            pEditor.setBorder(new CompoundBorder(new TitledBorder("Editor"), new EmptyBorder(new Insets(5, 5, 5, 5))));
            pEditor.add(olEditor);
            initEditorList();
            olEditor.setSelectedValue(defaultEditor.getName());
            getContentPane().add(getMainPanel());
            buildMenu();
            buildMnemonics();
            miHide.setMnemonic(KeyEvent.VK_H);
            miHide.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    pmEditor.setVisible(false);
                }
            });
            pack();
        }

        /**
         * Return OK_OPTION or CANCEL_OPTION respectively to pressed button.
         * @return
         */
        public int getOption() {
            return this.option;
        }

        /**
         * Return selected editor or null if editor is not selected.
         * @return
         */
        public EditorType getSelectedEditor() {
            return this.editor;
        }

        private EditorType getEditorForName(String name) {
            if (name == null) return null;
            EditorType[] types = EditorType.values();
            for (int i = 0; i < types.length; i++) {
                if (types[i].getName().equalsIgnoreCase(name)) return types[i];
            }
            return null;
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == bOk) {
                this.option = JOptionPane.OK_OPTION;
                String editorName = (String) olEditor.getSelectedValue();
                this.editor = getEditorForName(editorName);
                if (this.editor == null) {
                    showMessageDialog(this, "The editor is not supported", "Warning", WARNING_MESSAGE);
                    return;
                }
                setVisible(false);
            } else if (e.getSource() == bCancel) {
                this.option = JOptionPane.CANCEL_OPTION;
                setVisible(false);
            } else if (e.getSource() == bDefault) {
                olEditor.setSelectedValue(defaultEditor.getName());
            }  else if (e.getSource() == bSelect) {
                pmEditor.show(bSelect, bSelect.getSize().width / 2,  bSelect.getSize().height / 2);
            }
        }

    }

    private static void establishBounds(JDialog dialog) {
        Dimension d1 = dialog.getSize();
        Dimension d2 = dialog.getToolkit().getScreenSize();
        int x = Math.max((d2.width-d1.width)/2, 0);
        int y = Math.max((d2.height-d1.height)/2, 0);
        dialog.setBounds(x + 0, y + 0, d1.width, d1.height);
    }

    /**
     * Create and show encoding dialog. Return selected encoding ot null.
     * @return selected editor or null
     */
    public static EditorType showEditorDialog(String title) {
        EditorType editor = null;
        EditorChooser editorChooser = new EditorChooser();
        EditorDialog dialog = editorChooser.new EditorDialog(title);
        establishBounds(dialog);
        dialog.setVisible(true);
        if (dialog.getOption() == JOptionPane.OK_OPTION) {
            editor = dialog.getSelectedEditor();
        }
        dialog.dispose();
        return editor;
    }

    /**
     * Create and show encoding dialog. Return selected encoding ot null.
     * @return selected editor or null
     */
    public static EditorType showNewEditorDialog() {
        return showEditorDialog("New Editor");
    }

    /**
     * Create and show encoding dialog. Return selected encoding ot null.
     * @return selected editor or null
     */
    public static EditorType showChangeEditorDialog() {
        return showEditorDialog("Change Editor");
    }

    /**
     * Creates a menu of editors
     * @param multiTextComponent
     * @return JMenu
     */
    public static JMenu createEditorMenu(MultiTextComponent multiTextComponent) {
        EditorChooser chooser = new EditorChooser();
        EditorMenu menu = chooser.new EditorMenu(multiTextComponent);
        return menu.getMenu();
    }

}
