package neutrino.dialogs;

import neutrino.OpenList;

import java.awt.*;
import java.awt.event.*;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.*;
import javax.swing.border.*;

/**
 * Dialog for choosing character encoding.
 * @author Oleh Radvanskyj
 * @version 1.0
 */
public class EncodingChooser {
	
	private class EncodingDialog extends JDialog implements ActionListener {
		private JButton bOk = new JButton("Ok");
		private JButton bCancel = new JButton("Cancel");
		private JButton bDefault = new JButton("Default");
        private JButton bSelect = new JButton("Select");
		private OpenList olEncoding = new OpenList();
		private JPanel pEncoding = new JPanel(new GridLayout(1, 1, 1, 5));
		private int option = JOptionPane.CANCEL_OPTION;
		private Charset encoding = null;
		private Charset defaultEncoding = null;
        private JPopupMenu pmEncoding = new JPopupMenu();
        // European
        private JMenu mEuropean = new JMenu("European");
        private JMenuItem miXMacIceland = new JMenuItem("Icelandic (x-MacIceland)");
        private JMenuItem miISO88593 = new JMenuItem("South European (ISO-8859-3)");
        private JMenuItem miXMacCroatian = new JMenuItem("Croatian (x-MacCroatian)");
        private JMenuItem miXMacRomania = new JMenuItem("Romanian (x-MacRomania)");
        private JMenu mWesternEuropean = new JMenu("Western");
        private JMenuItem miISO88591 = new JMenuItem("ISO-8859-1");
        private JMenuItem miISO885915 = new JMenuItem("ISO-8859-15");
        private JMenuItem miIBM850 = new JMenuItem("IBM850");
        private JMenuItem miXMacRoman = new JMenuItem("x-MacRoman");
        private JMenuItem miWindows1252 = new JMenuItem("windows-1252");
        private JMenu mBaltic = new JMenu("Baltic");
        private JMenuItem miISO88594 = new JMenuItem("ISO-8859-4");
        private JMenuItem miISO885913 = new JMenuItem("ISO-8859-13");
        private JMenuItem miWindows1257 = new JMenuItem("windows-1257");
        private JMenu mCentralEuropean = new JMenu("Central European");
        private JMenuItem miISO88592 = new JMenuItem("ISO-8859-2");
        private JMenuItem miIBM852 = new JMenuItem("IBM852");
        private JMenuItem miWindows1250 = new JMenuItem("windows-1250");
        private JMenuItem miXMacCentralEurope = new JMenuItem("x-MacCentralEurope");
        private JMenu mCyrillic = new JMenu("Cyrillic");
        private JMenuItem miKOI8R = new JMenuItem("KOI8-R");
        private JMenuItem miISO88595 = new JMenuItem("ISO-8859-5");
        private JMenuItem miWindows1251 = new JMenuItem("windows-1251");
        private JMenuItem miKOI8U = new JMenuItem("KOI8-U");
        private JMenuItem miIBM866 = new JMenuItem("IBM866");
        private JMenuItem miXMacUkraine = new JMenuItem("x-MacUkraine");
        private JMenuItem miXMacCyrillic = new JMenuItem("x-MacCyrillic");
        private JMenu mGreek = new JMenu("Greek");
        private JMenuItem miISO88597 = new JMenuItem("ISO-8859-7");
        private JMenuItem miWindows1253 = new JMenuItem("windows-1253");
        private JMenuItem miXMacGreek = new JMenuItem("x-MacGreek");
        // Asian
        private JMenu mAsian = new JMenu("Asian");
        private JMenu mArabic = new JMenu("Arabic");
        private JMenuItem miISO88596 = new JMenuItem("ISO-8859-6");
        private JMenuItem miWindows1256 = new JMenuItem("windows-1256");
        private JMenuItem miXMacArabic = new JMenuItem("x-MacArabic");
        private JMenu mChienseSimplified = new JMenu("Chiense Simplified");
        private JMenuItem miGB18030 = new JMenuItem("GB18030");
        private JMenuItem miGBK = new JMenuItem("GBK");
        private JMenuItem miGB2312 = new JMenuItem("GB2312");
        private JMenuItem miISO2022CN = new JMenuItem("ISO-2022-CN");
        private JMenu mChienseTraditional = new JMenu("Chiense Traditional");
        private JMenuItem miBig5 = new JMenuItem("Big5");
        private JMenuItem miBig5HKSCS = new JMenuItem("Big5-HKSCS");
        private JMenuItem miXEUCTW = new JMenuItem("x-EUC-TW");
        private JMenuItem miXBig5Solaris = new JMenuItem("x-Big5-Solaris");
        private JMenu mHebrew = new JMenu("Hebrew");
        private JMenuItem miISO88598 = new JMenuItem("ISO-8859-8");
        private JMenuItem miWindows1255 = new JMenuItem("windows-1255");
        private JMenuItem miXMacHebrew = new JMenuItem("x-MacHebrew");
        private JMenuItem miIBM862 = new JMenuItem("IBM862");
        private JMenu mJapanese = new JMenu("Japanese");
        private JMenuItem miEUCJP = new JMenuItem("EUC-JP");
        private JMenuItem miISO2022JP = new JMenuItem("ISO-2022-JP");
        private JMenuItem miISO2022JP2 = new JMenuItem("ISO-2022-JP-2");
        private JMenuItem miXEucJpLinux = new JMenuItem("x-euc-jp-linux");
        private JMenuItem miXEucJPOpen = new JMenuItem("x-eucJP-Open");
        private JMenuItem miXWindowsIso2022jp = new JMenuItem("x-windows-iso2022jp");
        private JMenuItem miShiftJIS = new JMenuItem("Shift_JIS");
        private JMenuItem miJISX0201 = new JMenuItem("JIS_X0201");
        private JMenuItem miJISX02121990 = new JMenuItem("JIS_X0212-1990");
        private JMenuItem miXJIS0208 = new JMenuItem("x-JIS0208");
        private JMenuItem miXJISAutoDetect = new JMenuItem("x-JISAutoDetect");
        private JMenu mKorean = new JMenu("Korean");
        private JMenuItem miEUCKR = new JMenuItem("EUC-KR");
        private JMenuItem miXJohab = new JMenuItem("x-Johab");
        private JMenuItem miISO2022KR = new JMenuItem("ISO-2022-KR");
        private JMenu mThai = new JMenu("Thai");
        private JMenuItem miIBMThai = new JMenuItem("IBM-Thai");
        private JMenuItem miTIS620 = new JMenuItem("TIS-620");
        private JMenuItem miXISO885911 = new JMenuItem("x-iso-8859-11");
        private JMenuItem miXMacThai = new JMenuItem("x-MacThai");
        private JMenuItem miXWindows874 = new JMenuItem("x-windows-874");
        private JMenu mTurkish = new JMenu("Turkish");
        private JMenuItem miWindows1254 = new JMenuItem("windows-1254");
        private JMenuItem miISO88599 = new JMenuItem("ISO-8859-9");
        private JMenuItem miXMacTurkish = new JMenuItem("x-MacTurkish");
        private JMenuItem miIBM857 = new JMenuItem("IBM857");
        private JMenuItem miWindows1258 = new JMenuItem("Vietnamese (windows-1258)");
        // Unicode
        private JMenu mUnicode = new JMenu("Unicode");
        private JMenuItem miUTF16 = new JMenuItem("UTF-16");
        private JMenuItem miUTF16BE = new JMenuItem("UTF-16BE");
        private JMenuItem miUTF16LE = new JMenuItem("UTF-16LE");
        private JMenuItem miUTF32 = new JMenuItem("UTF-32");
        private JMenuItem miUTF32BE = new JMenuItem("UTF-32BE");
        private JMenuItem miUTF32LE = new JMenuItem("UTF-32LE");
        private JMenuItem miUTF8 = new JMenuItem("UTF-8");
        private JMenuItem miXUTF16LEBOM = new JMenuItem("x-UTF-16LE-BOM");
        private JMenuItem miXUTF32BEBOM = new JMenuItem("X-UTF-32BE-BOM");
        private JMenuItem miXUTF32LEBOM = new JMenuItem("X-UTF-32LE-BOM");
        private JMenuItem miHide = new JMenuItem("Hide");

        private void buildEncodingMenu() {
            // European
            pmEncoding.add(mEuropean);
            mEuropean.add(mBaltic);
            mBaltic.add(miISO88594);
            mBaltic.add(miISO885913);
            mBaltic.add(miWindows1257);
            mEuropean.add(mCentralEuropean);
            mCentralEuropean.add(miISO88592);
            mCentralEuropean.add(miIBM852);
            mCentralEuropean.add(miWindows1250);
            mCentralEuropean.add(miXMacCentralEurope);
            mEuropean.add(mCyrillic);
            mCyrillic.add(miKOI8R);
            mCyrillic.add(miISO88595);
            mCyrillic.add(miWindows1251);
            mCyrillic.add(miKOI8U);
            mCyrillic.add(miIBM866);
            mCyrillic.add(miXMacUkraine);
            mCyrillic.add(miXMacCyrillic);
            mEuropean.add(mGreek);
            mGreek.add(miISO88597);
            mGreek.add(miWindows1253);
            mGreek.add(miXMacGreek);
            mEuropean.add(mWesternEuropean);
            mWesternEuropean.add(miISO88591);
            mWesternEuropean.add(miISO885915);
            mWesternEuropean.add(miIBM850);
            mWesternEuropean.add(miXMacRoman);
            mWesternEuropean.add(miWindows1252);
            mEuropean.add(miXMacIceland);
            mEuropean.add(miISO88593);
            mEuropean.add(miXMacCroatian);
            mEuropean.add(miXMacRomania);
            // Asian
            pmEncoding.add(mAsian);
            mAsian.add(mArabic);
            mArabic.add(miISO88596);
            mArabic.add(miWindows1256);
            mArabic.add(miXMacArabic);
            mAsian.add(mChienseSimplified);
            mChienseSimplified.add(miGB18030);
            mChienseSimplified.add(miGBK);
            mChienseSimplified.add(miGB2312);
            mChienseSimplified.add(miISO2022CN);
            mAsian.add(mChienseTraditional);
            mChienseTraditional.add(miBig5);
            mChienseTraditional.add(miBig5HKSCS);
            mChienseTraditional.add(miXEUCTW);
            mChienseTraditional.add(miXBig5Solaris);
            mAsian.add(mHebrew);
            mHebrew.add(miISO88598);
            mHebrew.add(miWindows1255);
            mHebrew.add(miXMacHebrew);
            mHebrew.add(miIBM862);
            mAsian.add(mJapanese);
            mJapanese.add(miEUCJP);
            mJapanese.add(miISO2022JP);
            mJapanese.add(miISO2022JP2);
            mJapanese.add(miXEucJpLinux);
            mJapanese.add(miXEucJPOpen);
            mJapanese.add(miXWindowsIso2022jp);
            mJapanese.add(miShiftJIS);
            mJapanese.add(miJISX0201);
            mJapanese.add(miJISX02121990);
            mJapanese.add(miXJIS0208);
            mJapanese.add(miXJISAutoDetect);
            mAsian.add(mKorean);
            mKorean.add(miEUCKR);
            mKorean.add(miXJohab);
            mKorean.add(miISO2022KR);
            mAsian.add(mThai);
            mThai.add(miIBMThai);
            mThai.add(miTIS620);
            mThai.add(miXISO885911);
            mThai.add(miXMacThai);
            mThai.add(miXWindows874);
            mAsian.add(mTurkish);
            mTurkish.add(miWindows1254);
            mTurkish.add(miISO88599);
            mTurkish.add(miXMacTurkish);
            mTurkish.add(miIBM857);
            mAsian.add(miWindows1258);
            // Unicode
            pmEncoding.add(mUnicode);
            mUnicode.add(miUTF16);
            mUnicode.add(miUTF16BE);
            mUnicode.add(miUTF16LE);
            mUnicode.add(miUTF32);
            mUnicode.add(miUTF32BE);
            mUnicode.add(miUTF32LE);
            mUnicode.add(miUTF8);
            mUnicode.add(miXUTF16LEBOM);
            mUnicode.add(miXUTF32BEBOM);
            mUnicode.add(miXUTF32LEBOM);
            pmEncoding.add(miHide);
        }

        private void buildEncodingMenuMnemonics() {
            // European
            mEuropean.setMnemonic(KeyEvent.VK_E);
            miXMacIceland.setMnemonic(KeyEvent.VK_I);
            miISO88593.setMnemonic(KeyEvent.VK_S);
            miXMacCroatian.setMnemonic(KeyEvent.VK_M);
            miXMacRomania.setMnemonic(KeyEvent.VK_A);
            mBaltic.setMnemonic(KeyEvent.VK_B);
            miISO88594.setMnemonic(KeyEvent.VK_I);
            miISO885913.setMnemonic(KeyEvent.VK_S);
            miWindows1257.setMnemonic(KeyEvent.VK_W);
            mCentralEuropean.setMnemonic(KeyEvent.VK_C);
            miISO88592.setMnemonic(KeyEvent.VK_I);
            miIBM852.setMnemonic(KeyEvent.VK_B);
            miWindows1250.setMnemonic(KeyEvent.VK_W);
            miXMacCentralEurope.setMnemonic(KeyEvent.VK_X);
            mCyrillic.setMnemonic(KeyEvent.VK_Y);
            miKOI8R.setMnemonic(KeyEvent.VK_K);
            miISO88595.setMnemonic(KeyEvent.VK_I);
            miWindows1251.setMnemonic(KeyEvent.VK_W);
            miKOI8U.setMnemonic(KeyEvent.VK_O);
            miIBM866.setMnemonic(KeyEvent.VK_B);
            miXMacUkraine.setMnemonic(KeyEvent.VK_X);
            miXMacCyrillic.setMnemonic(KeyEvent.VK_M);
            mGreek.setMnemonic(KeyEvent.VK_G);
            miISO88597.setMnemonic(KeyEvent.VK_I);
            miWindows1253.setMnemonic(KeyEvent.VK_W);
            miXMacGreek.setMnemonic(KeyEvent.VK_X);
            mWesternEuropean.setMnemonic(KeyEvent.VK_W);
            miISO88591.setMnemonic(KeyEvent.VK_I);
            miISO885915.setMnemonic(KeyEvent.VK_S);
            miIBM850.setMnemonic(KeyEvent.VK_B);
            miXMacRoman.setMnemonic(KeyEvent.VK_X);
            miWindows1252.setMnemonic(KeyEvent.VK_W);
            // Asian
            mAsian.setMnemonic(KeyEvent.VK_A);
            mArabic.setMnemonic(KeyEvent.VK_A);
            miISO88596.setMnemonic(KeyEvent.VK_I);
            miWindows1256.setMnemonic(KeyEvent.VK_W);
            miXMacArabic.setMnemonic(KeyEvent.VK_X);
            mChienseSimplified.setMnemonic(KeyEvent.VK_I);
            miGB18030.setMnemonic(KeyEvent.VK_G);
            miGBK.setMnemonic(KeyEvent.VK_K);
            miGB2312.setMnemonic(KeyEvent.VK_B);
            miISO2022CN.setMnemonic(KeyEvent.VK_I);
            mChienseTraditional.setMnemonic(KeyEvent.VK_E);
            miBig5.setMnemonic(KeyEvent.VK_B);
            miBig5HKSCS.setMnemonic(KeyEvent.VK_I);
            miXEUCTW.setMnemonic(KeyEvent.VK_X);
            miXBig5Solaris.setMnemonic(KeyEvent.VK_X);
            mHebrew.setMnemonic(KeyEvent.VK_H);
            miISO88598.setMnemonic(KeyEvent.VK_I);
            miWindows1255.setMnemonic(KeyEvent.VK_W);
            miXMacHebrew.setMnemonic(KeyEvent.VK_X);
            miIBM862.setMnemonic(KeyEvent.VK_B);
            mJapanese.setMnemonic(KeyEvent.VK_J);
            miEUCJP.setMnemonic(KeyEvent.VK_E);
            miISO2022JP.setMnemonic(KeyEvent.VK_I);
            miISO2022JP2.setMnemonic(KeyEvent.VK_S);
            miXEucJpLinux.setMnemonic(KeyEvent.VK_X);
            miXEucJPOpen.setMnemonic(KeyEvent.VK_U);
            miXWindowsIso2022jp.setMnemonic(KeyEvent.VK_W);
            miShiftJIS.setMnemonic(KeyEvent.VK_H);
            miJISX0201.setMnemonic(KeyEvent.VK_J);
            miJISX02121990.setMnemonic(KeyEvent.VK_0);
            miXJIS0208.setMnemonic(KeyEvent.VK_2);
            miXJISAutoDetect.setMnemonic(KeyEvent.VK_A);
            mKorean.setMnemonic(KeyEvent.VK_J);
            miEUCKR.setMnemonic(KeyEvent.VK_E);
            miXJohab.setMnemonic(KeyEvent.VK_X);
            miISO2022KR.setMnemonic(KeyEvent.VK_I);
            mThai.setMnemonic(KeyEvent.VK_T);
            miIBMThai.setMnemonic(KeyEvent.VK_I);
            miTIS620.setMnemonic(KeyEvent.VK_T);
            miXISO885911.setMnemonic(KeyEvent.VK_X);
            miXMacThai.setMnemonic(KeyEvent.VK_M);
            miXWindows874.setMnemonic(KeyEvent.VK_W);
            mTurkish.setMnemonic(KeyEvent.VK_R);
            miWindows1254.setMnemonic(KeyEvent.VK_W);
            miISO88599.setMnemonic(KeyEvent.VK_I);
            miXMacTurkish.setMnemonic(KeyEvent.VK_X);
            miIBM857.setMnemonic(KeyEvent.VK_B);
            miWindows1258.setMnemonic(KeyEvent.VK_V);
            // Unicode
            mUnicode.setMnemonic(KeyEvent.VK_U);
            miUTF16.setMnemonic(KeyEvent.VK_U);
            miUTF16BE.setMnemonic(KeyEvent.VK_T);
            miUTF16LE.setMnemonic(KeyEvent.VK_F);
            miUTF32.setMnemonic(KeyEvent.VK_3);
            miUTF32BE.setMnemonic(KeyEvent.VK_2);
            miUTF32LE.setMnemonic(KeyEvent.VK_L);
            miUTF8.setMnemonic(KeyEvent.VK_8);
            miXUTF16LEBOM.setMnemonic(KeyEvent.VK_X);
            miXUTF32BEBOM.setMnemonic(KeyEvent.VK_B);
            miXUTF32LEBOM.setMnemonic(KeyEvent.VK_E);
            miHide.setMnemonic(KeyEvent.VK_H);
        }

        private void buildEncodingMenuListeners() {
            miISO88596.addActionListener(alEncoding);
            miWindows1256.addActionListener(alEncoding);
            miISO88594.addActionListener(alEncoding);
            miISO885913.addActionListener(alEncoding);
            miWindows1257.addActionListener(alEncoding);
            miISO88592.addActionListener(alEncoding);
            miISO88593.addActionListener(alEncoding);
            miWindows1250.addActionListener(alEncoding);
            miGB18030.addActionListener(alEncoding);
            miGBK.addActionListener(alEncoding);
            miGB2312.addActionListener(alEncoding);
            miBig5.addActionListener(alEncoding);
            miBig5HKSCS.addActionListener(alEncoding);
            miKOI8R.addActionListener(alEncoding);
            miISO88595.addActionListener(alEncoding);
            miWindows1251.addActionListener(alEncoding);
            miKOI8U.addActionListener(alEncoding);
            miIBM866.addActionListener(alEncoding);
            miISO88597.addActionListener(alEncoding);
            miWindows1253.addActionListener(alEncoding);
            miISO88598.addActionListener(alEncoding);
            miWindows1255.addActionListener(alEncoding);
            miEUCJP.addActionListener(alEncoding);
            miEUCKR.addActionListener(alEncoding);
            miXMacUkraine.addActionListener(alEncoding);
            miXMacCyrillic.addActionListener(alEncoding);
            miXMacGreek.addActionListener(alEncoding);
            miXJohab.addActionListener(alEncoding);
            miISO2022KR.addActionListener(alEncoding);
            miISO88591.addActionListener(alEncoding);
            miISO885915.addActionListener(alEncoding);
            miIBM850.addActionListener(alEncoding);
            miXMacRoman.addActionListener(alEncoding);
            miWindows1252.addActionListener(alEncoding);
            miXMacIceland.addActionListener(alEncoding);
            miIBM852.addActionListener(alEncoding);
            miXMacCentralEurope.addActionListener(alEncoding);
            miXMacArabic.addActionListener(alEncoding);
            miXMacCroatian.addActionListener(alEncoding);
            miXMacRomania.addActionListener(alEncoding);
            miISO2022CN.addActionListener(alEncoding);
            miXEUCTW.addActionListener(alEncoding);
            miISO2022JP.addActionListener(alEncoding);
            miISO2022JP2.addActionListener(alEncoding);
            miXEucJpLinux.addActionListener(alEncoding);
            miXEucJPOpen.addActionListener(alEncoding);
            miXWindowsIso2022jp.addActionListener(alEncoding);
            miShiftJIS.addActionListener(alEncoding);
            miXBig5Solaris.addActionListener(alEncoding);
            miIBMThai.addActionListener(alEncoding);
            miTIS620.addActionListener(alEncoding);
            miXISO885911.addActionListener(alEncoding);
            miXMacThai.addActionListener(alEncoding);
            miWindows1254.addActionListener(alEncoding);
            miISO88599.addActionListener(alEncoding);
            miXMacHebrew.addActionListener(alEncoding);
            miIBM862.addActionListener(alEncoding);
            miXWindows874.addActionListener(alEncoding);
            miIBM857.addActionListener(alEncoding);
            miWindows1258.addActionListener(alEncoding);
            miJISX0201.addActionListener(alEncoding);
            miJISX02121990.addActionListener(alEncoding);
            miXJIS0208.addActionListener(alEncoding);
            miXJISAutoDetect.addActionListener(alEncoding);
            miUTF16.addActionListener(alEncoding);
            miUTF16BE.addActionListener(alEncoding);
            miUTF16LE.addActionListener(alEncoding);
            miUTF32.addActionListener(alEncoding);
            miUTF32BE.addActionListener(alEncoding);
            miUTF32LE.addActionListener(alEncoding);
            miUTF8.addActionListener(alEncoding);
            miXUTF16LEBOM.addActionListener(alEncoding);
            miXUTF32BEBOM.addActionListener(alEncoding);
            miXUTF32LEBOM.addActionListener(alEncoding);
            miXMacTurkish.addActionListener(alEncoding);
            miHide.addActionListener(alEncoding);
        }

        private ActionListener alEncoding = new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == miHide) {
                    pmEncoding.setVisible(false);
                } else if (actionEvent.getSource() == miISO88596) {
                    olEncoding.setSelectedValue("ISO-8859-6");
                } else if (actionEvent.getSource() == miWindows1256) {
                    olEncoding.setSelectedValue("windows-1256");
                } else if (actionEvent.getSource() == miISO88594) {
                    olEncoding.setSelectedValue("ISO-8859-4");
                } else if (actionEvent.getSource() == miISO885913) {
                    olEncoding.setSelectedValue("ISO-8859-13");
                } else if (actionEvent.getSource() == miWindows1257) {
                    olEncoding.setSelectedValue("windows-1257");
                } else if (actionEvent.getSource() == miISO88592) {
                    olEncoding.setSelectedValue("ISO-8859-2");
                } else if (actionEvent.getSource() == miISO88593) {
                    olEncoding.setSelectedValue("ISO-8859-3");
                } else if (actionEvent.getSource() == miWindows1250) {
                    olEncoding.setSelectedValue("windows-1250");
                } else if (actionEvent.getSource() == miGB18030) {
                    olEncoding.setSelectedValue("GB18030");
                } else if (actionEvent.getSource() == miGBK) {
                    olEncoding.setSelectedValue("GBK");
                } else if (actionEvent.getSource() == miGB2312) {
                    olEncoding.setSelectedValue("GB2312");
                } else if (actionEvent.getSource() == miBig5) {
                    olEncoding.setSelectedValue("Big5");
                } else if (actionEvent.getSource() == miBig5HKSCS) {
                    olEncoding.setSelectedValue("Big5-HKSCS");
                } else if (actionEvent.getSource() == miKOI8R) {
                    olEncoding.setSelectedValue("KOI8-R");
                } else if (actionEvent.getSource() == miISO88595) {
                    olEncoding.setSelectedValue("ISO-8859-5");
                } else if (actionEvent.getSource() == miWindows1251) {
                    olEncoding.setSelectedValue("windows-1251");
                } else if (actionEvent.getSource() == miKOI8U) {
                    olEncoding.setSelectedValue("KOI8-U");
                } else if (actionEvent.getSource() == miIBM866) {
                    olEncoding.setSelectedValue("IBM866");
                } else if (actionEvent.getSource() == miISO88597) {
                    olEncoding.setSelectedValue("ISO-8859-7");
                } else if (actionEvent.getSource() == miWindows1253) {
                    olEncoding.setSelectedValue("windows-1253");
                } else if (actionEvent.getSource() == miISO88598) {
                    olEncoding.setSelectedValue("ISO-8859-8");
                } else if (actionEvent.getSource() == miWindows1255) {
                    olEncoding.setSelectedValue("windows-1255");
                } else if (actionEvent.getSource() == miEUCJP) {
                    olEncoding.setSelectedValue("EUC-JP");
                } else if (actionEvent.getSource() == miEUCKR) {
                    olEncoding.setSelectedValue("EUC-KR");
                } else if (actionEvent.getSource() == miXMacUkraine) {
                    olEncoding.setSelectedValue("x-MacUkraine");
                } else if (actionEvent.getSource() == miXMacCyrillic) {
                    olEncoding.setSelectedValue("x-MacCyrillic");
                } else if (actionEvent.getSource() == miXMacGreek) {
                    olEncoding.setSelectedValue("x-MacGreek");
                } else if (actionEvent.getSource() == miXJohab) {
                    olEncoding.setSelectedValue("x-Johab");
                } else if (actionEvent.getSource() == miISO2022KR) {
                    olEncoding.setSelectedValue("ISO-2022-KR");
                } else if (actionEvent.getSource() == miISO88591) {
                    olEncoding.setSelectedValue("ISO-8859-1");
                } else if (actionEvent.getSource() == miISO885915) {
                    olEncoding.setSelectedValue("ISO-8859-15");
                } else if (actionEvent.getSource() == miIBM850) {
                    olEncoding.setSelectedValue("IBM850");
                } else if (actionEvent.getSource() == miXMacRoman) {
                    olEncoding.setSelectedValue("x-MacRoman");
                } else if (actionEvent.getSource() == miWindows1252) {
                    olEncoding.setSelectedValue("windows-1252");
                } else if (actionEvent.getSource() == miXMacIceland) {
                    olEncoding.setSelectedValue("x-MacIceland");
                } else if (actionEvent.getSource() == miIBM852) {
                    olEncoding.setSelectedValue("IBM852");
                } else if (actionEvent.getSource() == miXMacCentralEurope) {
                    olEncoding.setSelectedValue("x-MacCentralEurope");
                } else if (actionEvent.getSource() == miXMacArabic) {
                    olEncoding.setSelectedValue("x-MacArabic");
                } else if (actionEvent.getSource() == miXMacCroatian) {
                    olEncoding.setSelectedValue("x-MacCroatian");
                } else if (actionEvent.getSource() == miXMacRomania) {
                    olEncoding.setSelectedValue("x-MacRomania");
                } else if (actionEvent.getSource() == miISO2022CN) {
                    olEncoding.setSelectedValue("ISO-2022-CN");
                } else if (actionEvent.getSource() == miXEUCTW) {
                    olEncoding.setSelectedValue("x-EUC-TW");
                } else if (actionEvent.getSource() == miISO2022JP) {
                    olEncoding.setSelectedValue("ISO-2022-JP");
                } else if (actionEvent.getSource() == miISO2022JP2) {
                    olEncoding.setSelectedValue("ISO-2022-JP-2");
                } else if (actionEvent.getSource() == miXEucJpLinux) {
                    olEncoding.setSelectedValue("x-euc-jp-linux");
                } else if (actionEvent.getSource() == miXEucJPOpen) {
                    olEncoding.setSelectedValue("x-eucJP-Open");
                } else if (actionEvent.getSource() == miXWindowsIso2022jp) {
                    olEncoding.setSelectedValue("x-windows-iso2022jp");
                } else if (actionEvent.getSource() == miShiftJIS) {
                    olEncoding.setSelectedValue("Shift_JIS");
                } else if (actionEvent.getSource() == miXBig5Solaris) {
                    olEncoding.setSelectedValue("x-Big5-Solaris");
                } else if (actionEvent.getSource() == miIBMThai) {
                    olEncoding.setSelectedValue("IBM-Thai");
                } else if (actionEvent.getSource() == miTIS620) {
                    olEncoding.setSelectedValue("TIS-620");
                } else if (actionEvent.getSource() == miXISO885911) {
                    olEncoding.setSelectedValue("x-iso-8859-11");
                } else if (actionEvent.getSource() == miXMacThai) {
                    olEncoding.setSelectedValue("x-MacThai");
                } else if (actionEvent.getSource() == miWindows1254) {
                    olEncoding.setSelectedValue("windows-1254");
                } else if (actionEvent.getSource() == miISO88599) {
                    olEncoding.setSelectedValue("ISO-8859-9");
                } else if (actionEvent.getSource() == miXMacTurkish) {
                    olEncoding.setSelectedValue("x-MacTurkish");
                } else if (actionEvent.getSource() == miXMacHebrew) {
                    olEncoding.setSelectedValue("x-MacHebrew");
                } else if (actionEvent.getSource() == miIBM862) {
                    olEncoding.setSelectedValue("IBM862");
                } else if (actionEvent.getSource() == miXWindows874) {
                    olEncoding.setSelectedValue("x-windows-874");
                } else if (actionEvent.getSource() == miIBM857) {
                    olEncoding.setSelectedValue("IBM857");
                } else if (actionEvent.getSource() == miWindows1258) {
                    olEncoding.setSelectedValue("windows-1258");
                } else if (actionEvent.getSource() == miJISX0201) {
                    olEncoding.setSelectedValue("JIS_X0201");
                } else if (actionEvent.getSource() == miJISX02121990) {
                    olEncoding.setSelectedValue("JIS_X0212-1990");
                } else if (actionEvent.getSource() == miXJIS0208) {
                    olEncoding.setSelectedValue("x-JIS0208");
                } else if (actionEvent.getSource() == miXJISAutoDetect) {
                    olEncoding.setSelectedValue("x-JISAutoDetect");
                } else if (actionEvent.getSource() == miUTF16) {
                    olEncoding.setSelectedValue("UTF-16");
                } else if (actionEvent.getSource() == miUTF16BE) {
                    olEncoding.setSelectedValue("UTF-16BE");
                } else if (actionEvent.getSource() == miUTF16LE) {
                    olEncoding.setSelectedValue("UTF-16LE");
                } else if (actionEvent.getSource() == miUTF32) {
                    olEncoding.setSelectedValue("UTF-32");
                } else if (actionEvent.getSource() == miUTF32BE) {
                    olEncoding.setSelectedValue("UTF-32BE");
                } else if (actionEvent.getSource() == miUTF32LE) {
                    olEncoding.setSelectedValue("UTF-32LE");
                } else if (actionEvent.getSource() == miUTF8) {
                    olEncoding.setSelectedValue("UTF-8");
                } else if (actionEvent.getSource() == miXUTF16LEBOM) {
                    olEncoding.setSelectedValue("x-UTF-16LE-BOM");
                } else if (actionEvent.getSource() == miXUTF32BEBOM) {
                    olEncoding.setSelectedValue("X-UTF-32BE-BOM");
                } else if (actionEvent.getSource() == miXUTF32LEBOM) {
                    olEncoding.setSelectedValue("X-UTF-32LE-BOM");
                }
            }
        };
			
		private JPanel getMainPanel() {
			JPanel panel = new JPanel();
			panel.setLayout(new GridBagLayout());
			GridBagConstraints c = new GridBagConstraints();
			c.gridx = 0;
			c.gridy = 0;
			c.gridheight = 5;
			c.insets = new Insets(5, 5, 5, 5);
			c.fill = GridBagConstraints.BOTH;
			panel.add(pEncoding, c);
			c.gridx = 1;
			c.gridy = 0;
			c.gridheight = 1;
			c.insets = new Insets(10, 0, 0, 5);
			c.fill = GridBagConstraints.HORIZONTAL;
			panel.add(bOk, c);
			c.gridx = 1;
			c.gridy = 1;
			c.gridheight = 1;
			c.insets = new Insets(5, 0, 0, 5);
			c.fill = GridBagConstraints.HORIZONTAL;
			panel.add(bCancel, c);
			c.gridx = 1;
			c.gridy = 2;
			c.gridheight = 1;
			c.insets = new Insets(5, 0, 0, 5);
			c.fill = GridBagConstraints.HORIZONTAL;
			panel.add(bDefault, c);
            c.gridx = 1;
            c.gridy = 3;
            c.gridheight = 1;
            c.insets = new Insets(5, 0, 0, 5);
            c.fill = GridBagConstraints.HORIZONTAL;
            panel.add(bSelect, c);
			return panel;
		}

		private void initEncodingList() {
			Iterator<String> iterator = Charset.availableCharsets().keySet().iterator();
			Vector<String> listData = new Vector<String>();
			while (iterator.hasNext()) {
				listData.add(iterator.next());
			}
            olEncoding.setListData(listData, true);
		}

        private void buildButtonMnemonics() {
            bOk.setMnemonic(KeyEvent.VK_O);
            bCancel.setMnemonic(KeyEvent.VK_C);
            bDefault.setMnemonic(KeyEvent.VK_D);
            bSelect.setMnemonic(KeyEvent.VK_S);
        }

        private void buildButtonListeners() {
            bOk.addActionListener(this);
            bCancel.addActionListener(this);
            bDefault.addActionListener(this);
            bSelect.addActionListener(this);
        }

        private void buildButtonToolTipTexts() {
            bOk.setToolTipText("Set encoding");
            bCancel.setToolTipText("Abort encoding choosing dialog");
            bDefault.setToolTipText("Select default encoding");
            bSelect.setToolTipText("Select encoding from menu");
        }
		
		public EncodingDialog(JFrame owner, Charset currentEncoding, Charset defaultEncoding) {
			super(owner);
			setTitle("Encoding");
			setModal(true);
			setResizable(false);
			setDefaultCloseOperation(DISPOSE_ON_CLOSE);
			getRootPane().setDefaultButton(bOk);
            buildButtonMnemonics();
            buildButtonListeners();
            buildButtonToolTipTexts();
            olEncoding.setSize(new Dimension(200, 230));
            olEncoding.setFixedSelectedValue(true);
			pEncoding.setBorder(new CompoundBorder(new TitledBorder("Encoding"), new EmptyBorder(new Insets(5, 5, 5, 5))));
			pEncoding.add(olEncoding);
            initEncodingList();
			if (defaultEncoding != null) {
				this.defaultEncoding = defaultEncoding;
			} else {
				this.defaultEncoding = Charset.defaultCharset();
			}
            olEncoding.setSelectedValue(currentEncoding.name());
            getContentPane().add(getMainPanel());
            buildEncodingMenu();
            buildEncodingMenuMnemonics();
            buildEncodingMenuListeners();
            pack();
		}
		
		/**
		 * Return OK_OPTION or CANCEL_OPTION respectively to pressed button. 
		 * @return
		 */
		public int getOption() {
			return this.option;
		}
		
		/**
		 * Return selected encoding or null is encoding is not selected. 
		 * @return
		 */
		public Charset getSelectedEncoding() {
			return this.encoding;
		}
		
		public void actionPerformed(ActionEvent e) {
			if (e.getSource() == bOk) {
				this.option = JOptionPane.OK_OPTION;
				String charsetName = (String) olEncoding.getSelectedValue();
				if (charsetName != null && Charset.isSupported(charsetName)) {
					this.encoding = Charset.forName(charsetName);
				}
				setVisible(false);
			} else if (e.getSource() == bCancel) {
				this.option = JOptionPane.CANCEL_OPTION;
				setVisible(false);
			} else if (e.getSource() == bDefault) {
                olEncoding.setSelectedValue(defaultEncoding.name());
			}  else if (e.getSource() == bSelect) {
               pmEncoding.show(bSelect, bSelect.getSize().width / 2,  bSelect.getSize().height / 2);
            }
		}
	}
	
	private static void establishBounds(JDialog dialog, Window owner) {
	      Dimension d1 = dialog.getSize();
	      Dimension d2 = owner.getSize();
	      Dimension ds = dialog.getToolkit().getScreenSize();
	      int x = Math.max((d2.width-d1.width)/2, 0);
	      int y = Math.max((d2.height-d1.height)/2, 0);
	      int xshift = ((x + d1.width + owner.getX()) > ds.width) ? (((ds.width - d1.width) / 2) - x) : owner.getX();
	      int yshift = ((y + d1.height + owner.getY()) > ds.height) ? (((ds.height - d1.height) / 2) - y) : owner.getY();
	      dialog.setBounds(x + xshift, y + yshift, d1.width, d1.height);
	}
		
	/**
	 * Create and show encoding dialog. Return selected encoding ot null.
	 * @param owner - parent frame
	 * @param currentEncoding - current selected encoding 
	 * @param defaultEncoding - default encoding 
	 * @return selected encoding or null
	 */
	public static Charset showEncodingDialog(JFrame owner, Charset currentEncoding, Charset defaultEncoding) {
		Charset encoding = null;
		EncodingChooser encodingChooser = new EncodingChooser();
		EncodingDialog dialog = encodingChooser.new EncodingDialog(owner, currentEncoding, defaultEncoding);
		establishBounds(dialog, owner);
		dialog.setVisible(true);
		if (dialog.getOption() == JOptionPane.OK_OPTION) {
			encoding = dialog.getSelectedEncoding();
		}
		dialog.dispose();
		return encoding;
	}

	/**
	 * Create and show encoding dialog. Return selected encoding ot null.
	 * @param owner - parent frame
	 * @param currentEncoding - current selected encoding 
	 * @return selected encoding or null
	 */
	public static Charset showEncodingDialog(JFrame owner, Charset currentEncoding) {
		Charset encoding = null;
		EncodingChooser encodingChooser = new EncodingChooser();
		EncodingDialog dialog = encodingChooser.new EncodingDialog(owner, currentEncoding, null);
		establishBounds(dialog, owner);
		dialog.setVisible(true);
		if (dialog.getOption() == JOptionPane.OK_OPTION) {
			encoding = dialog.getSelectedEncoding();
		}
		dialog.dispose();
		return encoding;
	}

}
