package neutrino.dialogs;

import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import java.awt.event.ActionListener;
import java.net.URL;

/**
 * Dialog for viewing the help pages
 * @author Oleh Radvanskyj
 * @version 1.0
 */
public class HelpChooser {

    public static ActionListener getActionListener(String fileName) {
        ClassLoader cl = HelpChooser.class.getClassLoader();
        HelpSet hs = null;
        try {
            URL hsURL = HelpSet.findHelpSet(cl, fileName);
            hs = new HelpSet(null, hsURL);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        HelpBroker hb = hs.createHelpBroker();
        return new CSH.DisplayHelpFromSource(hb);
    }

}
