package neutrino.dialogs;

import neutrino.text.TextEditor;
import neutrino.text.components.plain.PlainTextArea;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.print.PrinterException;
import java.io.File;
import static javax.swing.JOptionPane.*;

/**
 * Contains Payment dialog for viewing the payment information
 * @author Oleh Radvanskyj
 * @version 1.0
 * Date: 10/7/15
 * Time: 9:14 PM
 */
public class PaymentChooser {

    private class PaymentDialog extends JDialog {

        private int WIDTH = 650;
        private int HEIGHT = 400;
        private PlainTextArea textComponent;
        private TextEditor textEditor;
        private JScrollPane scrollPane;
        private JButton bPrint = new JButton("Print...");
        private JButton bClose = new JButton("Close");

        private JPanel getButtonsPanel() {
            bPrint.setMnemonic(KeyEvent.VK_P);
            bClose.setMnemonic(KeyEvent.VK_C);
            bPrint.setToolTipText("Print the payment information");
            bClose.setToolTipText("Abort payment chooser dialog");
            bPrint.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        textComponent.print();
                    } catch (PrinterException e) {
                        showMessageDialog(getOwner(), e.getMessage(), "Error", ERROR_MESSAGE);
                    }
                }
            });
            bClose.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    setVisible(false);
                    dispose();
                }
            });
            JPanel buttonsPanel = new JPanel();
            BoxLayout buttonsLayout = new BoxLayout(buttonsPanel, BoxLayout.X_AXIS);
            buttonsPanel.setLayout(buttonsLayout);
            buttonsPanel.add(Box.createHorizontalGlue());
            buttonsPanel.add(bPrint);
            buttonsPanel.add(Box.createHorizontalStrut(5));
            buttonsPanel.add(bClose);
            buttonsPanel.add(Box.createHorizontalGlue());
            JPanel panel = new JPanel();
            BoxLayout layout = new BoxLayout(panel, BoxLayout.Y_AXIS);
            panel.add(Box.createVerticalStrut(5));
            panel.add(buttonsPanel);
            panel.add(Box.createVerticalStrut(5));
            return panel;
        }

        public PaymentDialog(JFrame owner, File licenseFile) {
            super(owner);
            setTitle("Payment");
            setSize(WIDTH, HEIGHT);
            setDefaultCloseOperation(DISPOSE_ON_CLOSE);
            setModal(false);
            setAlwaysOnTop(false);
            setResizable(true);
            establishBounds(this);
            textComponent = new PlainTextArea();
            textComponent.setEditable(false);
            textComponent.setMargin(new Insets(20, 20, 20, 20));
            Font font = new Font(Font.MONOSPACED, Font.BOLD, 14);
            textComponent.setFont(font);
            scrollPane = new JScrollPane();
            scrollPane.getViewport().setView(textComponent);
            getContentPane().setLayout(new BorderLayout());
            getContentPane().add(scrollPane, BorderLayout.CENTER);
            getContentPane().add(getButtonsPanel(), BorderLayout.SOUTH);
            textEditor = new TextEditor(textComponent);
            if (textEditor.open(licenseFile)) {
                setVisible(true);
            };
        }

    }

    private static void establishBounds(JDialog dialog) {
        Dimension d1 = dialog.getSize();
        Dimension d2 = dialog.getToolkit().getScreenSize();
        int x = Math.max((d2.width-d1.width)/2, 0);
        int y = Math.max((d2.height-d1.height)/2, 0);
        dialog.setBounds(x + 0, y + 0, d1.width, d1.height);
    }

    /**
     * Shows Payment dialog
     * @param owner - the frame owner of dialog
     * @param paymentFile - the text file
     */
    public static void showPaymentDialog(JFrame owner, File paymentFile) {
        PaymentChooser paymentChooser = new PaymentChooser();
        PaymentDialog dialog = paymentChooser.new PaymentDialog(owner, paymentFile);
    }

}
